\name{BinaryPruningImageFilter}
\alias{BinaryPruningImageFilter}
\title{BinaryPruningImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter removes "spurs" of less than a certain length in the
input image.
BinaryPruningImageFilter}
\details{
This class is parameterized over the type of the input image and the
type of the output image.
The input is assumed to be a binary image.
This filter is a sequential pruning algorithm and known to be
computational time dependable of the image size. The algorithm is the
N-dimensional version of that given for two dimensions in:
Rafael C. Gonzales and Richard E. Woods. Digital Image Processing. Addison Wesley, 491-494, (1993).
See:
MorphologyImageFilter
BinaryErodeImageFilter
BinaryDilateImageFilter
BinaryThinningImageFilter
BinaryPruning for the procedural interface
itk::BinaryPruningImageFilter for the Doxygen on the original ITK class.
BinaryPruningImageFilter}
%C++ includes: sitkBinaryPruningImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryPruningImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{uint32_t GetIteration() const:}{
Set/Get the iteration value
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetIteration(uint32_t Iteration):}{
Set/Get the iteration value
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryPruningImageFilter():}{
Destructor
}
}
}
