\name{CenteredVersorTransformInitializerFilter}
\alias{CenteredVersorTransformInitializerFilter}
\title{CenteredVersorTransformInitializerFilter}
\Rdversion{1.1}
\docType{class}
\description{
CenteredVersorTransformInitializerFilter is a helper class intended to initialize the center of rotation,
versor, and translation of the VersorRigid3DTransform.
CenteredVersorTransformInitializerFilter}
\details{
This class is derived from the CenteredTransformInitializerFilter and uses it in a more constrained context. It always uses the Moments
mode, and also takes advantage of the second order moments in order to
initialize the Versor representing rotation.
See:
itk::CenteredVersorTransformInitializer for the Doxygen on the original ITK class.
CenteredVersorTransformInitializerFilter}
%C++ includes: sitkCenteredVersorTransformInitializerFilter.h
\section{Methods}{
\describe{
\item{ CenteredVersorTransformInitializerFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self ComputeRotationOff():}{}
\item{Self ComputeRotationOn():}{
Set the value of ComputeRotation to true or false respectfully.
}
\item{Transform Execute(const Image &fixedImage, const Image &movingImage, const Transform &transform):}{
Execute the filter on the input image
}
\item{bool GetComputeRotation() const:}{
Enable the use of the principal axes of each image to compute an
initial rotation that will align them.
}
\item{std::string GetName() const override:}{
Name of this class
}
\item{Self SetComputeRotation(bool ComputeRotation):}{
Enable the use of the principal axes of each image to compute an
initial rotation that will align them.
}
\item{std::string ToString() const override:}{
Print ourselves out
}
\item{ ~CenteredVersorTransformInitializerFilter() override:}{
Destructor
}
}
}
