/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.apache.pdfbox.pdmodel.interactive.form.PDChoiceField;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDPushButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDRadioCollection;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextbox;
import org.apache.pdfbox.pdmodel.interactive.form.PDUnknownField;

public class PDFieldFactory {
    private static final int RADIO_BITMASK = 32768;
    private static final int PUSHBUTTON_BITMASK = 65536;
    private static final String FIELD_TYPE_BTN = "Btn";
    private static final String FIELD_TYPE_TX = "Tx";
    private static final String FIELD_TYPE_CH = "Ch";
    private static final String FIELD_TYPE_SIG = "Sig";

    private PDFieldFactory() {
    }

    public static PDField createField(PDAcroForm acroForm, COSDictionary field) throws IOException {
        PDField pdField = new PDUnknownField(acroForm, field);
        if (PDFieldFactory.isButton(pdField)) {
            int flags = pdField.getFieldFlags();
            pdField = PDFieldFactory.isRadio(flags) ? new PDRadioCollection(acroForm, field) : (PDFieldFactory.isPushButton(flags) ? new PDPushButton(acroForm, field) : new PDCheckbox(acroForm, field));
        } else if (PDFieldFactory.isChoiceField(pdField)) {
            pdField = new PDChoiceField(acroForm, field);
        } else if (PDFieldFactory.isTextbox(pdField)) {
            pdField = new PDTextbox(acroForm, field);
        } else if (PDFieldFactory.isSignature(pdField)) {
            pdField = new PDSignatureField(acroForm, field);
        }
        return pdField;
    }

    private static boolean isRadio(int flags) {
        return (flags & 0x8000) > 0;
    }

    private static boolean isPushButton(int flags) {
        return (flags & 0x10000) > 0;
    }

    private static boolean isChoiceField(PDField field) throws IOException {
        return FIELD_TYPE_CH.equals(field.findFieldType());
    }

    private static boolean isButton(PDField field) throws IOException {
        String ft = field.findFieldType();
        return FIELD_TYPE_BTN.equals(ft);
    }

    private static boolean isSignature(PDField field) throws IOException {
        return FIELD_TYPE_SIG.equals(field.findFieldType());
    }

    private static boolean isTextbox(PDField field) throws IOException {
        return FIELD_TYPE_TX.equals(field.findFieldType());
    }
}

