/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.tagplugin.TagPlugin;
import org.apache.jasper.compiler.tagplugin.TagPluginContext;
import org.apache.tomcat.util.descriptor.tagplugin.TagPluginParser;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;
import org.xml.sax.SAXException;

public class TagPluginManager {
    private static final String META_INF_JASPER_TAG_PLUGINS_XML = "META-INF/org.apache.jasper/tagPlugins.xml";
    private static final String TAG_PLUGINS_XML = "/WEB-INF/tagPlugins.xml";
    private final ServletContext ctxt;
    private HashMap<String, TagPlugin> tagPlugins;
    private boolean initialized = false;

    public TagPluginManager(ServletContext servletContext) {
        this.ctxt = servletContext;
    }

    public void apply(Node.Nodes nodes, ErrorDispatcher errorDispatcher, PageInfo pageInfo) throws JasperException {
        this.init(errorDispatcher);
        if (!this.tagPlugins.isEmpty()) {
            nodes.visit(new NodeVisitor(this, pageInfo));
        }
    }

    private void init(ErrorDispatcher errorDispatcher) throws JasperException {
        TagPluginParser tagPluginParser;
        ClassLoader classLoader;
        Object object;
        if (this.initialized) {
            return;
        }
        String string = this.ctxt.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
        boolean bl = string == null ? true : Boolean.parseBoolean(string);
        Thread thread = Thread.currentThread();
        if (Constants.IS_SECURITY_ENABLED) {
            object = new PrivilegedGetTccl(thread);
            classLoader = (ClassLoader)AccessController.doPrivileged(object);
        } else {
            classLoader = thread.getContextClassLoader();
        }
        try {
            Object object2;
            if (Constants.IS_SECURITY_ENABLED) {
                object = new PrivilegedSetTccl(thread, TagPluginManager.class.getClassLoader());
                AccessController.doPrivileged(object);
            } else {
                thread.setContextClassLoader(TagPluginManager.class.getClassLoader());
            }
            tagPluginParser = new TagPluginParser(this.ctxt, bl);
            object = this.ctxt.getClassLoader().getResources(META_INF_JASPER_TAG_PLUGINS_XML);
            while (object.hasMoreElements()) {
                object2 = (URL)object.nextElement();
                tagPluginParser.parse((URL)object2);
            }
            object2 = this.ctxt.getResource(TAG_PLUGINS_XML);
            if (object2 != null) {
                tagPluginParser.parse((URL)object2);
            }
        }
        catch (IOException | SAXException exception) {
            throw new JasperException(exception);
        }
        finally {
            if (Constants.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(thread, classLoader);
                AccessController.doPrivileged(privilegedSetTccl);
            } else {
                thread.setContextClassLoader(classLoader);
            }
        }
        object = tagPluginParser.getPlugins();
        this.tagPlugins = new HashMap(object.size());
        for (Map.Entry entry : object.entrySet()) {
            try {
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                Class<?> clazz = this.ctxt.getClassLoader().loadClass(string3);
                TagPlugin tagPlugin = (TagPlugin)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.tagPlugins.put(string2, tagPlugin);
            }
            catch (Exception exception) {
                errorDispatcher.jspError(exception);
            }
        }
        this.initialized = true;
    }

    private void invokePlugin(Node.CustomTag customTag, PageInfo pageInfo) {
        TagPlugin tagPlugin = this.tagPlugins.get(customTag.getTagHandlerClass().getName());
        if (tagPlugin == null) {
            return;
        }
        TagPluginContextImpl tagPluginContextImpl = new TagPluginContextImpl(customTag, pageInfo);
        customTag.setTagPluginContext(tagPluginContextImpl);
        tagPlugin.doTag(tagPluginContextImpl);
    }

    private static class NodeVisitor
    extends Node.Visitor {
        private final TagPluginManager manager;
        private final PageInfo pageInfo;

        NodeVisitor(TagPluginManager tagPluginManager, PageInfo pageInfo) {
            this.manager = tagPluginManager;
            this.pageInfo = pageInfo;
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            this.manager.invokePlugin(customTag, this.pageInfo);
            this.visitBody(customTag);
        }
    }

    private static class TagPluginContextImpl
    implements TagPluginContext {
        private final Node.CustomTag node;
        private final PageInfo pageInfo;
        private final HashMap<String, Object> pluginAttributes;
        private Node.Nodes curNodes;

        TagPluginContextImpl(Node.CustomTag customTag, PageInfo pageInfo) {
            this.node = customTag;
            this.pageInfo = pageInfo;
            this.curNodes = new Node.Nodes();
            customTag.setAtETag(this.curNodes);
            this.curNodes = new Node.Nodes();
            customTag.setAtSTag(this.curNodes);
            customTag.setUseTagPlugin(true);
            this.pluginAttributes = new HashMap();
        }

        @Override
        public TagPluginContext getParentContext() {
            Node node = this.node.getParent();
            if (!(node instanceof Node.CustomTag)) {
                return null;
            }
            return ((Node.CustomTag)node).getTagPluginContext();
        }

        @Override
        public void setPluginAttribute(String string, Object object) {
            this.pluginAttributes.put(string, object);
        }

        @Override
        public Object getPluginAttribute(String string) {
            return this.pluginAttributes.get(string);
        }

        @Override
        public boolean isScriptless() {
            return this.node.getChildInfo().isScriptless();
        }

        @Override
        public boolean isConstantAttribute(String string) {
            Node.JspAttribute jspAttribute = this.getNodeAttribute(string);
            if (jspAttribute == null) {
                return false;
            }
            return jspAttribute.isLiteral();
        }

        @Override
        public String getConstantAttribute(String string) {
            Node.JspAttribute jspAttribute = this.getNodeAttribute(string);
            if (jspAttribute == null) {
                return null;
            }
            return jspAttribute.getValue();
        }

        @Override
        public boolean isAttributeSpecified(String string) {
            return this.getNodeAttribute(string) != null;
        }

        @Override
        public String getTemporaryVariableName() {
            return this.node.getRoot().nextTemporaryVariableName();
        }

        @Override
        public void generateImport(String string) {
            this.pageInfo.addImport(string);
        }

        @Override
        public void generateDeclaration(String string, String string2) {
            if (this.pageInfo.isPluginDeclared(string)) {
                return;
            }
            this.curNodes.add(new Node.Declaration(string2, this.node.getStart(), null));
        }

        @Override
        public void generateJavaSource(String string) {
            this.curNodes.add(new Node.Scriptlet(string, this.node.getStart(), null));
        }

        @Override
        public void generateAttribute(String string) {
            this.curNodes.add(new Node.AttributeGenerator(this.node.getStart(), string, this.node));
        }

        @Override
        public void dontUseTagPlugin() {
            this.node.setUseTagPlugin(false);
        }

        @Override
        public void generateBody() {
            this.curNodes = this.node.getAtETag();
        }

        @Override
        public boolean isTagFile() {
            return this.pageInfo.isTagFile();
        }

        private Node.JspAttribute getNodeAttribute(String string) {
            Node.JspAttribute[] jspAttributeArray = this.node.getJspAttributes();
            for (int i = 0; jspAttributeArray != null && i < jspAttributeArray.length; ++i) {
                if (!jspAttributeArray[i].getName().equals(string)) continue;
                return jspAttributeArray[i];
            }
            return null;
        }
    }
}

