/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.jcajce.spec.HybridValueParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;

class JcaJcePGPUtil {
    JcaJcePGPUtil() {
    }

    public static SecretKey makeSymmetricKey(int n, byte[] byArray) throws PGPException {
        String string = PGPUtil.getSymmetricCipherName(n);
        if (string == null) {
            throw new PGPException("unknown symmetric algorithm: " + n);
        }
        return new SecretKeySpec(byArray, string);
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) throws IOException {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray((BigInteger)bigInteger));
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            return ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    static HybridValueParameterSpec getHybridValueParameterSpecWithPrepend(byte[] byArray, PublicKeyPacket publicKeyPacket, String string) throws IOException {
        return new HybridValueParameterSpec(Arrays.concatenate((byte[])byArray, (byte[])publicKeyPacket.getKey().getEncoded()), true, (AlgorithmParameterSpec)new UserKeyingMaterialSpec(Strings.toByteArray((String)("OpenPGP " + string))));
    }

    static Key getSecret(OperatorHelper operatorHelper, PublicKey publicKey, String string, String string2, AlgorithmParameterSpec algorithmParameterSpec, Key key) throws GeneralSecurityException {
        KeyAgreement keyAgreement = operatorHelper.createKeyAgreement(string2);
        keyAgreement.init(key, algorithmParameterSpec);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret(string);
    }

    static boolean isX25519(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return aSN1ObjectIdentifier.equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519) || aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_X25519);
    }
}

