/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.binding.Initializer;
import org.jruby.javasupport.binding.MethodGatherer;
import org.jruby.runtime.ThreadContext;

final class ClassInitializer
extends Initializer {
    ClassInitializer(Ruby runtime2, Class<?> javaClass) {
        super(runtime2, javaClass);
    }

    @Override
    public RubyClass initialize(ThreadContext context, RubyModule proxy2) {
        RubyClass proxyClass = (RubyClass)proxy2;
        proxy2.setJavaProxy(true);
        proxy2.singletonClass(context).setJavaProxy(true);
        Class<?> enclosingClass = this.javaClass.getEnclosingClass();
        RubyModule parent = enclosingClass != null ? Java.getProxyClass(context, enclosingClass) : Java.getJavaPackageModule(this.runtime, this.javaClass.getPackage());
        proxy2.setParent(parent);
        proxy2.baseName(this.javaClass.isMemberClass() ? this.javaClass.getSimpleName() : this.inferBaseNameFromJavaName(enclosingClass));
        proxyClass.getName(context);
        MethodGatherer state2 = new MethodGatherer(this.runtime, this.javaClass.getSuperclass());
        state2.initialize(context, this.javaClass, proxy2);
        return proxyClass;
    }

    private String inferBaseNameFromJavaName(Class<?> enclosingClass) {
        String baseName = this.javaClass.getSimpleName();
        if (enclosingClass != null) {
            int offset2;
            String className = this.javaClass.getName();
            int length2 = className.length();
            if (length2 > (offset2 = enclosingClass.getName().length()) && className.charAt(offset2) != '$') {
                baseName = className.substring(offset2);
            } else if (length2 > offset2 + 1) {
                baseName = className.substring(offset2 + 1);
            }
        }
        return baseName;
    }
}

