/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestGetSettingsAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetSettingsAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_settings"), new RestHandler.Route(RestRequest.Method.GET, "/_settings/{name}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_settings"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_settings/{name}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_setting/{name}")));
    }

    @Override
    public String getName() {
        return "get_settings_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] names = request.paramAsStringArrayOrEmptyIfAll("name");
        boolean renderDefaults = request.paramAsBoolean("include_defaults", false);
        request.paramAsBoolean("flat_settings", false);
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(Strings.splitStringByCommaToArray((String)request.param("index"))).indicesOptions(IndicesOptions.fromRequest(request, IndicesOptions.strictExpandOpen())).humanReadable(request.hasParam("human")).includeDefaults(renderDefaults).names(names);
        getSettingsRequest.local(request.paramAsBoolean("local", getSettingsRequest.local()));
        getSettingsRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", getSettingsRequest.clusterManagerNodeTimeout()));
        RestGetSettingsAction.parseDeprecatedMasterTimeoutParameter(getSettingsRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().indices().getSettings(getSettingsRequest, new RestToXContentListener<GetSettingsResponse>((RestChannel)channel));
    }
}

