"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addClickToMetric = addClickToMetric;
exports.addRequestToMetric = addRequestToMetric;
exports.getMetrics = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("./constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const time2CountWin = new Map();
function addClickToMetric(element, counter = 'count') {
  // remove outdated key-value pairs
  trim();
  const timeKey = getKey(Date.now());
  const rollingCounter = time2CountWin.get(timeKey) || _lodash.default.cloneDeep(_constants.DEFAULT_ROLLING_COUNTER);
  const key = `click.${element}.${counter}`;
  _lodash.default.set(rollingCounter, key, _lodash.default.get(rollingCounter, key, 0) + 1);
  if (counter === 'count') {
    const basicCounterKey = `click.${element}.total`;
    _lodash.default.set(_constants.GLOBAL_BASIC_COUNTER, basicCounterKey, _lodash.default.get(_constants.GLOBAL_BASIC_COUNTER, basicCounterKey, 0) + 1);
  }
  time2CountWin.set(timeKey, rollingCounter);
}
function addRequestToMetric(component, request, counterNameOrError) {
  const counter = typeof counterNameOrError === 'object' ? checkErrorType(counterNameOrError) : counterNameOrError;

  // remove outdated key-value pairs
  trim();
  const timeKey = getKey(Date.now());
  const rollingCounter = time2CountWin.get(timeKey) || _lodash.default.cloneDeep(_constants.DEFAULT_ROLLING_COUNTER);
  rollingCounter[component][request][counter]++;
  if (counter === 'count') {
    _constants.GLOBAL_BASIC_COUNTER[component][request].total++;
  }
  time2CountWin.set(timeKey, rollingCounter);
}
const getMetrics = () => {
  const preTimeKey = getPreKey(Date.now());
  const rollingCounters = time2CountWin.get(preTimeKey);
  return buildMetrics(rollingCounters);
};
exports.getMetrics = getMetrics;
const checkErrorType = error => {
  if (error.statusCode && Math.floor(error.statusCode / 100) === 4) {
    return 'user_error';
  } else {
    return 'system_error';
  }
};
const trim = () => {
  if (time2CountWin.size > _constants.CAPACITY) {
    const currentKey = getKey(Date.now() - _constants.WINDOW * _constants.MILLIS_MULTIPLIER);
    time2CountWin.forEach((_value, key, map) => {
      if (key < currentKey) {
        map.delete(key);
      }
    });
  }
};
const getKey = milliseconds => {
  return Math.floor(milliseconds / _constants.MILLIS_MULTIPLIER / _constants.INTERVAL);
};
const getPreKey = milliseconds => {
  return getKey(milliseconds) - 1;
};
const isComponent = arg => {
  return _constants.COMPONENTS.includes(arg);
};
const buildMetrics = rollingCounters => {
  if (!rollingCounters) {
    rollingCounters = _constants.DEFAULT_ROLLING_COUNTER;
  }
  const basicMetrics = _lodash.default.merge(rollingCounters, _constants.GLOBAL_BASIC_COUNTER);
  const overallActionMetrics = {
    request_total: 0,
    request_count: 0,
    success_count: 0,
    failed_request_count_system_error: 0,
    failed_request_count_user_error: 0
  };
  Object.keys(basicMetrics).forEach(key => {
    if (isComponent(key)) {
      for (const counter of Object.values(basicMetrics[key])) {
        overallActionMetrics.request_count += (counter === null || counter === void 0 ? void 0 : counter.count) || 0;
        overallActionMetrics.request_total += (counter === null || counter === void 0 ? void 0 : counter.total) || 0;
        overallActionMetrics.failed_request_count_system_error += (counter === null || counter === void 0 ? void 0 : counter.system_error) || 0;
        overallActionMetrics.failed_request_count_user_error += (counter === null || counter === void 0 ? void 0 : counter.user_error) || 0;
      }
    }
  });
  overallActionMetrics.success_count = overallActionMetrics.request_count - (overallActionMetrics.failed_request_count_system_error + overallActionMetrics.failed_request_count_user_error);
  return {
    ...basicMetrics,
    ...overallActionMetrics
  };
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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