/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.util.concurrent.UncategorizedExecutionException;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ContextParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.BoostingQueryBuilder;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.DisMaxQueryBuilder;
import org.opensearch.index.query.DistanceFeatureQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.FieldMaskingSpanQueryBuilder;
import org.opensearch.index.query.FuzzyQueryBuilder;
import org.opensearch.index.query.GeoBoundingBoxQueryBuilder;
import org.opensearch.index.query.GeoDistanceQueryBuilder;
import org.opensearch.index.query.GeoPolygonQueryBuilder;
import org.opensearch.index.query.GeoShapeQueryBuilder;
import org.opensearch.index.query.IdsQueryBuilder;
import org.opensearch.index.query.IntervalQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.MatchBoolPrefixQueryBuilder;
import org.opensearch.index.query.MatchNoneQueryBuilder;
import org.opensearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.MoreLikeThisQueryBuilder;
import org.opensearch.index.query.MultiMatchQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.PrefixQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.RegexpQueryBuilder;
import org.opensearch.index.query.ScriptQueryBuilder;
import org.opensearch.index.query.SimpleQueryStringBuilder;
import org.opensearch.index.query.SpanContainingQueryBuilder;
import org.opensearch.index.query.SpanFirstQueryBuilder;
import org.opensearch.index.query.SpanNearQueryBuilder;
import org.opensearch.index.query.SpanNotQueryBuilder;
import org.opensearch.index.query.SpanOrQueryBuilder;
import org.opensearch.index.query.SpanTermQueryBuilder;
import org.opensearch.index.query.SpanWithinQueryBuilder;
import org.opensearch.index.query.TemplateQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.query.TermsSetQueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.index.query.WrapperQueryBuilder;
import org.opensearch.remote.metadata.client.BulkDataObjectResponse;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.PutDataObjectResponse;
import org.opensearch.remote.metadata.client.SearchDataObjectResponse;
import org.opensearch.remote.metadata.client.UpdateDataObjectResponse;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.bucket.adjacency.ParsedAdjacencyMatrix;
import org.opensearch.search.aggregations.bucket.composite.ParsedComposite;
import org.opensearch.search.aggregations.bucket.filter.ParsedFilter;
import org.opensearch.search.aggregations.bucket.filter.ParsedFilters;
import org.opensearch.search.aggregations.bucket.global.ParsedGlobal;
import org.opensearch.search.aggregations.bucket.histogram.ParsedAutoDateHistogram;
import org.opensearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.opensearch.search.aggregations.bucket.histogram.ParsedHistogram;
import org.opensearch.search.aggregations.bucket.histogram.ParsedVariableWidthHistogram;
import org.opensearch.search.aggregations.bucket.missing.ParsedMissing;
import org.opensearch.search.aggregations.bucket.nested.ParsedNested;
import org.opensearch.search.aggregations.bucket.nested.ParsedReverseNested;
import org.opensearch.search.aggregations.bucket.range.ParsedBinaryRange;
import org.opensearch.search.aggregations.bucket.range.ParsedDateRange;
import org.opensearch.search.aggregations.bucket.range.ParsedGeoDistance;
import org.opensearch.search.aggregations.bucket.range.ParsedRange;
import org.opensearch.search.aggregations.bucket.sampler.ParsedSampler;
import org.opensearch.search.aggregations.bucket.terms.ParsedDoubleTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedMultiTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedSignificantLongTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedSignificantStringTerms;
import org.opensearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.opensearch.search.aggregations.metrics.ParsedAvg;
import org.opensearch.search.aggregations.metrics.ParsedCardinality;
import org.opensearch.search.aggregations.metrics.ParsedExtendedStats;
import org.opensearch.search.aggregations.metrics.ParsedGeoCentroid;
import org.opensearch.search.aggregations.metrics.ParsedHDRPercentileRanks;
import org.opensearch.search.aggregations.metrics.ParsedHDRPercentiles;
import org.opensearch.search.aggregations.metrics.ParsedMax;
import org.opensearch.search.aggregations.metrics.ParsedMedianAbsoluteDeviation;
import org.opensearch.search.aggregations.metrics.ParsedMin;
import org.opensearch.search.aggregations.metrics.ParsedScriptedMetric;
import org.opensearch.search.aggregations.metrics.ParsedStats;
import org.opensearch.search.aggregations.metrics.ParsedSum;
import org.opensearch.search.aggregations.metrics.ParsedTDigestPercentileRanks;
import org.opensearch.search.aggregations.metrics.ParsedTDigestPercentiles;
import org.opensearch.search.aggregations.metrics.ParsedTopHits;
import org.opensearch.search.aggregations.metrics.ParsedValueCount;
import org.opensearch.search.aggregations.metrics.ParsedWeightedAvg;
import org.opensearch.search.aggregations.pipeline.ParsedBucketMetricValue;
import org.opensearch.search.aggregations.pipeline.ParsedDerivative;
import org.opensearch.search.aggregations.pipeline.ParsedExtendedStatsBucket;
import org.opensearch.search.aggregations.pipeline.ParsedPercentilesBucket;
import org.opensearch.search.aggregations.pipeline.ParsedSimpleValue;
import org.opensearch.search.aggregations.pipeline.ParsedStatsBucket;

public class SdkClientUtils {
    private static final Logger log = LogManager.getLogger(SdkClientUtils.class);
    private static final NamedXContentRegistry DEFAULT_XCONTENT_REGISTRY = SdkClientUtils.createDefaultXContentRegistry();

    private SdkClientUtils() {
    }

    @SafeVarargs
    public static BiConsumer<PutDataObjectResponse, Throwable> wrapPutCompletion(ActionListener<IndexResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            IndexResponse indexResponse = r.indexResponse();
            if (indexResponse == null) {
                SdkClientUtils.handleParseFailure(listener, "index");
                return;
            }
            log.info("Put success for {} in {}", (Object)indexResponse.getId(), (Object)indexResponse.getIndex());
            listener.onResponse((Object)indexResponse);
        };
    }

    @SafeVarargs
    public static BiConsumer<GetDataObjectResponse, Throwable> wrapGetCompletion(ActionListener<GetResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            GetResponse getResponse = r.getResponse();
            if (getResponse == null) {
                SdkClientUtils.handleParseFailure(listener, "get");
                return;
            }
            log.info("Get success for {} in {}", (Object)getResponse.getId(), (Object)getResponse.getIndex());
            listener.onResponse((Object)getResponse);
        };
    }

    @SafeVarargs
    public static BiConsumer<UpdateDataObjectResponse, Throwable> wrapUpdateCompletion(ActionListener<UpdateResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            UpdateResponse updateResponse = r.updateResponse();
            if (updateResponse == null) {
                SdkClientUtils.handleParseFailure(listener, "update");
                return;
            }
            log.info("Update success for {} in {}", (Object)updateResponse.getId(), (Object)updateResponse.getIndex());
            listener.onResponse((Object)updateResponse);
        };
    }

    @SafeVarargs
    public static BiConsumer<DeleteDataObjectResponse, Throwable> wrapDeleteCompletion(ActionListener<DeleteResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            DeleteResponse deleteResponse = r.deleteResponse();
            if (deleteResponse == null) {
                SdkClientUtils.handleParseFailure(listener, "delete");
                return;
            }
            log.info("Deleate success for {} in {}", (Object)deleteResponse.getId(), (Object)deleteResponse.getIndex());
            listener.onResponse((Object)deleteResponse);
        };
    }

    @SafeVarargs
    public static BiConsumer<BulkDataObjectResponse, Throwable> wrapBulkCompletion(ActionListener<BulkResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            BulkResponse bulkResponse = r.bulkResponse();
            if (bulkResponse == null) {
                SdkClientUtils.handleParseFailure(listener, "bulk");
                return;
            }
            log.info("Bulk complete for {} items. {} failures.", (Object)bulkResponse.getItems().length, (Object)SdkClientUtils.countBulkFailures(bulkResponse));
            listener.onResponse((Object)bulkResponse);
        };
    }

    private static long countBulkFailures(BulkResponse bulkResponse) {
        if (bulkResponse.hasFailures()) {
            return Arrays.stream(bulkResponse.getItems()).filter(BulkItemResponse::isFailed).count();
        }
        return 0L;
    }

    @SafeVarargs
    public static BiConsumer<SearchDataObjectResponse, Throwable> wrapSearchCompletion(ActionListener<SearchResponse> listener, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        return (r, throwable) -> {
            if (throwable != null) {
                SdkClientUtils.handleThrowable(listener, throwable, exceptionTypesToUnwrap);
                return;
            }
            SearchResponse searchResponse = r.searchResponse();
            if (searchResponse == null) {
                SdkClientUtils.handleParseFailure(listener, "search");
                return;
            }
            log.info("Search complete. {}.", (Object)searchResponse.getHits().getTotalHits());
            listener.onResponse((Object)searchResponse);
        };
    }

    public static XContentParser createParser(ToXContent obj) throws IOException {
        return SdkClientUtils.createParser(Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)obj));
    }

    public static XContentParser createParser(String json) throws IOException {
        return JsonXContent.jsonXContent.createParser(DEFAULT_XCONTENT_REGISTRY, DeprecationHandler.IGNORE_DEPRECATIONS, json);
    }

    private static void handleParseFailure(ActionListener<?> listener, String operation) {
        listener.onFailure((Exception)new OpenSearchStatusException("Failed to parse " + operation + " response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
    }

    @SafeVarargs
    private static void handleThrowable(ActionListener<?> listener, Throwable throwable, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        Exception exception = exceptionTypesToUnwrap.length > 0 ? SdkClientUtils.unwrapAndConvertToException(throwable, exceptionTypesToUnwrap) : SdkClientUtils.unwrapAndConvertToException(throwable, OpenSearchStatusException.class, CompletionException.class);
        listener.onFailure(exception);
    }

    @SafeVarargs
    public static Exception unwrapAndConvertToException(Throwable throwable, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        Throwable cause;
        List<Class<? extends Throwable>> unwrapTypes = exceptionTypesToUnwrap.length > 0 ? Arrays.asList(exceptionTypesToUnwrap) : List.of(CompletionException.class);
        for (cause = throwable; cause != null && unwrapTypes.contains(cause.getClass()) && cause.getCause() != null; cause = cause.getCause()) {
        }
        if ((cause = SdkClientUtils.getRethrownExecutionExceptionRootCause(cause)) instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (cause instanceof Exception) {
            return (Exception)cause;
        }
        return new OpenSearchException(cause);
    }

    public static Throwable getRethrownExecutionExceptionRootCause(Throwable throwable) {
        if (throwable instanceof UncategorizedExecutionException && throwable.getCause() instanceof ExecutionException) {
            return throwable.getCause().getCause();
        }
        return throwable;
    }

    @Deprecated
    public static String lowerCaseEnumValues(String field, String json) {
        if (field == null) {
            return json;
        }
        if (json == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("(\"" + Pattern.quote(field) + "\"):(\"[A-Z_]+\")").matcher(json);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1) + ":" + matcher.group(2).toLowerCase(Locale.ROOT));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static NamedXContentRegistry createDefaultXContentRegistry() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.addAll(SdkClientUtils.getDefaultNamedXContents());
        return new NamedXContentRegistry(entries);
    }

    private static List<NamedXContentRegistry.Entry> getDefaultNamedXContents() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        Map queryMap = Map.ofEntries(Map.entry("bool", (p, c) -> BoolQueryBuilder.fromXContent((XContentParser)p)), Map.entry("boosting", (p, c) -> BoostingQueryBuilder.fromXContent((XContentParser)p)), Map.entry("constant_score", (p, c) -> ConstantScoreQueryBuilder.fromXContent((XContentParser)p)), Map.entry("dis_max", (p, c) -> DisMaxQueryBuilder.fromXContent((XContentParser)p)), Map.entry("distance_feature", (p, c) -> DistanceFeatureQueryBuilder.fromXContent((XContentParser)p)), Map.entry("exists", (p, c) -> ExistsQueryBuilder.fromXContent((XContentParser)p)), Map.entry("span_field_masking", (p, c) -> FieldMaskingSpanQueryBuilder.fromXContent((XContentParser)p)), Map.entry("fuzzy", (p, c) -> FuzzyQueryBuilder.fromXContent((XContentParser)p)), Map.entry("geo_bounding_box", (p, c) -> GeoBoundingBoxQueryBuilder.fromXContent((XContentParser)p)), Map.entry("geo_distance", (p, c) -> GeoDistanceQueryBuilder.fromXContent((XContentParser)p)), Map.entry("geo_polygon", (p, c) -> GeoPolygonQueryBuilder.fromXContent((XContentParser)p)), Map.entry("geo_shape", (p, c) -> GeoShapeQueryBuilder.fromXContent((XContentParser)p)), Map.entry("ids", (p, c) -> IdsQueryBuilder.fromXContent((XContentParser)p)), Map.entry("intervals", (p, c) -> IntervalQueryBuilder.fromXContent((XContentParser)p)), Map.entry("match_all", (p, c) -> MatchAllQueryBuilder.fromXContent((XContentParser)p)), Map.entry("match_bool_prefix", (p, c) -> MatchBoolPrefixQueryBuilder.fromXContent((XContentParser)p)), Map.entry("match_none", (p, c) -> MatchNoneQueryBuilder.fromXContent((XContentParser)p)), Map.entry("match_phrase_prefix", (p, c) -> MatchPhrasePrefixQueryBuilder.fromXContent((XContentParser)p)), Map.entry("match_phrase", (p, c) -> MatchPhraseQueryBuilder.fromXContent((XContentParser)p)), Map.entry("match", (p, c) -> MatchQueryBuilder.fromXContent((XContentParser)p)), Map.entry("more_like_this", (p, c) -> MoreLikeThisQueryBuilder.fromXContent((XContentParser)p)), Map.entry("multi_match", (p, c) -> MultiMatchQueryBuilder.fromXContent((XContentParser)p)), Map.entry("nested", (p, c) -> NestedQueryBuilder.fromXContent((XContentParser)p)), Map.entry("prefix", (p, c) -> PrefixQueryBuilder.fromXContent((XContentParser)p)), Map.entry("query_string", (p, c) -> QueryStringQueryBuilder.fromXContent((XContentParser)p)), Map.entry("range", (p, c) -> RangeQueryBuilder.fromXContent((XContentParser)p)), Map.entry("regexp", (p, c) -> RegexpQueryBuilder.fromXContent((XContentParser)p)), Map.entry("script", (p, c) -> ScriptQueryBuilder.fromXContent((XContentParser)p)), Map.entry("simple_query_string", (p, c) -> SimpleQueryStringBuilder.fromXContent((XContentParser)p)), Map.entry("span_containing", (p, c) -> SpanContainingQueryBuilder.fromXContent((XContentParser)p)), Map.entry("span_first", (p, c) -> SpanFirstQueryBuilder.fromXContent((XContentParser)p)), Map.entry("span_near", (p, c) -> SpanNearQueryBuilder.fromXContent((XContentParser)p)), Map.entry("span_not", (p, c) -> SpanNotQueryBuilder.fromXContent((XContentParser)p)), Map.entry("span_or", (p, c) -> SpanOrQueryBuilder.fromXContent((XContentParser)p)), Map.entry("span_term", (p, c) -> SpanTermQueryBuilder.fromXContent((XContentParser)p)), Map.entry("span_within", (p, c) -> SpanWithinQueryBuilder.fromXContent((XContentParser)p)), Map.entry("template", (p, c) -> TemplateQueryBuilder.fromXContent((XContentParser)p)), Map.entry("term", (p, c) -> TermQueryBuilder.fromXContent((XContentParser)p)), Map.entry("terms", (p, c) -> TermsQueryBuilder.fromXContent((XContentParser)p)), Map.entry("terms_set", (p, c) -> TermsSetQueryBuilder.fromXContent((XContentParser)p)), Map.entry("wildcard", (p, c) -> WildcardQueryBuilder.fromXContent((XContentParser)p)), Map.entry("wrapper", (p, c) -> WrapperQueryBuilder.fromXContent((XContentParser)p)));
        entries.addAll(queryMap.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(QueryBuilder.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).collect(Collectors.toList()));
        Map aggMap = Map.ofEntries(Map.entry("avg", (p, c) -> ParsedAvg.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("weighted_avg", (p, c) -> ParsedWeightedAvg.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("sum", (p, c) -> ParsedSum.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("min", (p, c) -> ParsedMin.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("max", (p, c) -> ParsedMax.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("stats", (p, c) -> ParsedStats.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("extended_stats", (p, c) -> ParsedExtendedStats.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("value_count", (p, c) -> ParsedValueCount.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("tdigest_percentiles", (p, c) -> ParsedTDigestPercentiles.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("hdr_percentiles", (p, c) -> ParsedHDRPercentiles.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("tdigest_percentile_ranks", (p, c) -> ParsedTDigestPercentileRanks.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("hdr_percentile_ranks", (p, c) -> ParsedHDRPercentileRanks.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("median_absolute_deviation", (p, c) -> ParsedMedianAbsoluteDeviation.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("cardinality", (p, c) -> ParsedCardinality.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("global", (p, c) -> ParsedGlobal.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("missing", (p, c) -> ParsedMissing.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("filter", (p, c) -> ParsedFilter.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("filters", (p, c) -> ParsedFilters.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("adjacency_matrix", (p, c) -> ParsedAdjacencyMatrix.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("mapped_sampler", (p, c) -> ParsedSampler.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("sterms", (p, c) -> ParsedStringTerms.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("lterms", (p, c) -> ParsedLongTerms.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("dterms", (p, c) -> ParsedDoubleTerms.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("siglterms", (p, c) -> ParsedSignificantLongTerms.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("sigsterms", (p, c) -> ParsedSignificantStringTerms.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("range", (p, c) -> ParsedRange.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("date_range", (p, c) -> ParsedDateRange.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("ip_range", (p, c) -> ParsedBinaryRange.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("histogram", (p, c) -> ParsedHistogram.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("date_histogram", (p, c) -> ParsedDateHistogram.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("auto_date_histogram", (p, c) -> ParsedAutoDateHistogram.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("variable_width_histogram", (p, c) -> ParsedVariableWidthHistogram.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("geo_distance", (p, c) -> ParsedGeoDistance.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("nested", (p, c) -> ParsedNested.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("reverse_nested", (p, c) -> ParsedReverseNested.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("top_hits", (p, c) -> ParsedTopHits.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("geo_centroid", (p, c) -> ParsedGeoCentroid.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("scripted_metric", (p, c) -> ParsedScriptedMetric.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("composite", (p, c) -> ParsedComposite.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("multi_terms", (p, c) -> ParsedMultiTerms.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("percentiles_bucket", (p, c) -> ParsedPercentilesBucket.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("simple_value", (p, c) -> ParsedSimpleValue.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("derivative", (p, c) -> ParsedDerivative.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("bucket_metric_value", (p, c) -> ParsedBucketMetricValue.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("stats_bucket", (p, c) -> ParsedStatsBucket.fromXContent((XContentParser)p, (String)((String)c))), Map.entry("extended_stats_bucket", (p, c) -> ParsedExtendedStatsBucket.fromXContent((XContentParser)p, (String)((String)c))));
        entries.addAll(aggMap.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(Aggregation.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).collect(Collectors.toList()));
        return entries;
    }
}

