/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.actionlevel;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.selectivem.collections.CheckTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.security.privileges.IndexPattern;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.privileges.actionlevel.RuntimeOptimizedActionPrivileges;
import org.opensearch.security.privileges.actionlevel.WellKnownActions;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.FlattenedActionGroups;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.support.WildcardMatcher;

public class SubjectBasedActionPrivileges
extends RuntimeOptimizedActionPrivileges {
    private static final Logger log = LogManager.getLogger(SubjectBasedActionPrivileges.class);

    public SubjectBasedActionPrivileges(RoleV7 role, FlattenedActionGroups actionGroups) {
        super(new ClusterPrivileges(actionGroups.resolve(role.getCluster_permissions())), new IndexPrivileges(role, actionGroups));
    }

    @Override
    protected RuntimeOptimizedActionPrivileges.StatefulIndexPrivileges currentStatefulIndexPrivileges() {
        return null;
    }

    static class ClusterPrivileges
    extends RuntimeOptimizedActionPrivileges.ClusterPrivileges {
        private final ImmutableSet<String> grantedActions;
        private final boolean providesWildcardPrivilege;
        private final WildcardMatcher grantedActionMatcher;

        ClusterPrivileges(ImmutableSet<String> permissionPatterns) {
            HashSet<String> grantedActions = new HashSet<String>();
            boolean hasWildcardPermission = false;
            ArrayList<WildcardMatcher> wildcardMatchers = new ArrayList<WildcardMatcher>();
            for (String permission : permissionPatterns) {
                if (WildcardMatcher.isExact(permission)) {
                    grantedActions.add(permission);
                    continue;
                }
                if (permission.equals("*")) {
                    hasWildcardPermission = true;
                    continue;
                }
                WildcardMatcher wildcardMatcher = WildcardMatcher.from(permission);
                Set matchedActions = wildcardMatcher.getMatchAny((Collection<String>)WellKnownActions.CLUSTER_ACTIONS, Collectors.toUnmodifiableSet());
                grantedActions.addAll(matchedActions);
                wildcardMatchers.add(wildcardMatcher);
            }
            this.grantedActions = ImmutableSet.copyOf(grantedActions);
            this.providesWildcardPrivilege = hasWildcardPermission;
            this.grantedActionMatcher = WildcardMatcher.from(wildcardMatchers);
        }

        @Override
        protected boolean checkWildcardPrivilege(PrivilegesEvaluationContext context) {
            return this.providesWildcardPrivilege;
        }

        @Override
        protected boolean checkPrivilegeForWellKnownAction(PrivilegesEvaluationContext context, String action) {
            return this.grantedActions.contains((Object)action);
        }

        @Override
        protected boolean checkPrivilegeViaActionMatcher(PrivilegesEvaluationContext context, String action) {
            return this.grantedActionMatcher.test(action);
        }
    }

    static class IndexPrivileges
    extends RuntimeOptimizedActionPrivileges.StaticIndexPrivileges {
        private final ImmutableMap<String, IndexPattern> actionToIndexPattern;
        private final ImmutableMap<WildcardMatcher, IndexPattern> actionPatternToIndexPattern;
        private final ImmutableSet<String> actionsWithWildcardIndexPrivileges;
        private final ImmutableMap<String, IndexPattern> explicitActionToIndexPattern;

        IndexPrivileges(RoleV7 role, FlattenedActionGroups actionGroups) {
            HashMap<String, IndexPattern.Builder> actionToIndexPattern = new HashMap<String, IndexPattern.Builder>();
            HashMap<WildcardMatcher, IndexPattern.Builder> actionPatternToIndexPattern = new HashMap<WildcardMatcher, IndexPattern.Builder>();
            HashSet<String> actionWithWildcardIndexPrivileges = new HashSet<String>();
            HashMap<String, IndexPattern.Builder> explicitActionToIndexPattern = new HashMap<String, IndexPattern.Builder>();
            for (RoleV7.Index indexPermissions : role.getIndex_permissions()) {
                ImmutableSet<String> permissions = actionGroups.resolve(indexPermissions.getAllowed_actions());
                for (String permission : permissions) {
                    if (WildcardMatcher.isExact(permission)) {
                        actionToIndexPattern.computeIfAbsent(permission, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                        if (WellKnownActions.EXPLICITLY_REQUIRED_INDEX_ACTIONS.contains((Object)permission)) {
                            explicitActionToIndexPattern.computeIfAbsent(permission, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                        }
                        if (!indexPermissions.getIndex_patterns().contains("*")) continue;
                        actionWithWildcardIndexPrivileges.add(permission);
                        continue;
                    }
                    WildcardMatcher actionMatcher = WildcardMatcher.from(permission);
                    for (String action : actionMatcher.iterateMatching((Iterable<String>)WellKnownActions.INDEX_ACTIONS)) {
                        actionToIndexPattern.computeIfAbsent(action, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                        if (!indexPermissions.getIndex_patterns().contains("*")) continue;
                        actionWithWildcardIndexPrivileges.add(permission);
                    }
                    actionPatternToIndexPattern.computeIfAbsent(actionMatcher, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                    if (actionMatcher == WildcardMatcher.ANY) continue;
                    for (String action : actionMatcher.iterateMatching((Iterable<String>)WellKnownActions.EXPLICITLY_REQUIRED_INDEX_ACTIONS)) {
                        explicitActionToIndexPattern.computeIfAbsent(action, k -> new IndexPattern.Builder()).add(indexPermissions.getIndex_patterns());
                    }
                }
            }
            this.actionToIndexPattern = (ImmutableMap)actionToIndexPattern.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((IndexPattern.Builder)entry.getValue()).build()));
            this.actionPatternToIndexPattern = (ImmutableMap)actionPatternToIndexPattern.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((IndexPattern.Builder)entry.getValue()).build()));
            this.actionsWithWildcardIndexPrivileges = ImmutableSet.copyOf(actionWithWildcardIndexPrivileges);
            this.explicitActionToIndexPattern = (ImmutableMap)explicitActionToIndexPattern.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((IndexPattern.Builder)entry.getValue()).build()));
        }

        @Override
        protected PrivilegesEvaluatorResponse providesPrivilege(PrivilegesEvaluationContext context, Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices, CheckTable<String, String> checkTable) {
            ArrayList<PrivilegesEvaluationException> exceptions = new ArrayList<PrivilegesEvaluationException>();
            this.checkPrivilegeWithIndexPatternOnWellKnownActions(context, actions, checkTable, this.actionToIndexPattern, exceptions);
            if (checkTable.isComplete()) {
                return PrivilegesEvaluatorResponse.ok();
            }
            if (!WellKnownActions.allWellKnownIndexActions(actions)) {
                this.checkPrivilegesForNonWellKnownActions(context, actions, checkTable, this.actionPatternToIndexPattern, exceptions);
                if (checkTable.isComplete()) {
                    return PrivilegesEvaluatorResponse.ok();
                }
            }
            return this.responseForIncompletePrivileges(context, resolvedIndices, checkTable, exceptions);
        }

        @Override
        protected PrivilegesEvaluatorResponse checkWildcardIndexPrivilegesOnWellKnownActions(PrivilegesEvaluationContext context, Set<String> actions) {
            for (String action : actions) {
                if (this.actionsWithWildcardIndexPrivileges.contains((Object)action)) continue;
                return null;
            }
            return PrivilegesEvaluatorResponse.ok();
        }

        @Override
        protected PrivilegesEvaluatorResponse providesExplicitPrivilege(PrivilegesEvaluationContext context, Set<String> actions, CheckTable<String, String> checkTable) {
            Map<String, IndexAbstraction> indexMetadata = context.getIndicesLookup();
            ArrayList<PrivilegesEvaluationException> exceptions = new ArrayList<PrivilegesEvaluationException>();
            for (String action : actions) {
                IndexPattern indexPattern = (IndexPattern)this.explicitActionToIndexPattern.get((Object)action);
                if (indexPattern == null) continue;
                for (String index : checkTable.iterateUncheckedRows((Object)action)) {
                    try {
                        if (!indexPattern.matches(index, context, indexMetadata) || !checkTable.check((Object)index, (Object)action)) continue;
                        return PrivilegesEvaluatorResponse.ok();
                    }
                    catch (PrivilegesEvaluationException e) {
                        log.error("Error while evaluating {}. Ignoring entry", (Object)indexPattern, (Object)e);
                        exceptions.add(new PrivilegesEvaluationException("Error while evaluating " + String.valueOf(indexPattern), e));
                    }
                }
            }
            return PrivilegesEvaluatorResponse.insufficient(checkTable).reason("No explicit privileges have been provided for the referenced indices.").evaluationExceptions(exceptions);
        }
    }
}

