/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by MockGen. DO NOT EDIT.
// Source: ./siteinfo_service.go
//
// Generated by this command:
//
//	mockgen -source=./siteinfo_service.go -destination=../mock/siteinfo_repo_mock.go -package=mock
//

// Package mock is a generated GoMock package.
package mock

import (
	context "context"
	reflect "reflect"

	entity "github.com/apache/answer/internal/entity"
	schema "github.com/apache/answer/internal/schema"
	gomock "go.uber.org/mock/gomock"
)

// MockSiteInfoRepo is a mock of SiteInfoRepo interface.
type MockSiteInfoRepo struct {
	ctrl     *gomock.Controller
	recorder *MockSiteInfoRepoMockRecorder
	isgomock struct{}
}

// MockSiteInfoRepoMockRecorder is the mock recorder for MockSiteInfoRepo.
type MockSiteInfoRepoMockRecorder struct {
	mock *MockSiteInfoRepo
}

// NewMockSiteInfoRepo creates a new mock instance.
func NewMockSiteInfoRepo(ctrl *gomock.Controller) *MockSiteInfoRepo {
	mock := &MockSiteInfoRepo{ctrl: ctrl}
	mock.recorder = &MockSiteInfoRepoMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockSiteInfoRepo) EXPECT() *MockSiteInfoRepoMockRecorder {
	return m.recorder
}

// GetByType mocks base method.
func (m *MockSiteInfoRepo) GetByType(ctx context.Context, siteType string) (*entity.SiteInfo, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetByType", ctx, siteType)
	ret0, _ := ret[0].(*entity.SiteInfo)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// GetByType indicates an expected call of GetByType.
func (mr *MockSiteInfoRepoMockRecorder) GetByType(ctx, siteType any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetByType", reflect.TypeOf((*MockSiteInfoRepo)(nil).GetByType), ctx, siteType)
}

// IsBrandingFileUsed mocks base method.
func (m *MockSiteInfoRepo) IsBrandingFileUsed(ctx context.Context, filePath string) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsBrandingFileUsed", ctx, filePath)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// IsBrandingFileUsed indicates an expected call of IsBrandingFileUsed.
func (mr *MockSiteInfoRepoMockRecorder) IsBrandingFileUsed(ctx, filePath any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsBrandingFileUsed", reflect.TypeOf((*MockSiteInfoRepo)(nil).IsBrandingFileUsed), ctx, filePath)
}

// SaveByType mocks base method.
func (m *MockSiteInfoRepo) SaveByType(ctx context.Context, siteType string, data *entity.SiteInfo) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SaveByType", ctx, siteType, data)
	ret0, _ := ret[0].(error)
	return ret0
}

// SaveByType indicates an expected call of SaveByType.
func (mr *MockSiteInfoRepoMockRecorder) SaveByType(ctx, siteType, data any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SaveByType", reflect.TypeOf((*MockSiteInfoRepo)(nil).SaveByType), ctx, siteType, data)
}

// MockSiteInfoCommonService is a mock of SiteInfoCommonService interface.
type MockSiteInfoCommonService struct {
	ctrl     *gomock.Controller
	recorder *MockSiteInfoCommonServiceMockRecorder
	isgomock struct{}
}

// MockSiteInfoCommonServiceMockRecorder is the mock recorder for MockSiteInfoCommonService.
type MockSiteInfoCommonServiceMockRecorder struct {
	mock *MockSiteInfoCommonService
}

// NewMockSiteInfoCommonService creates a new mock instance.
func NewMockSiteInfoCommonService(ctrl *gomock.Controller) *MockSiteInfoCommonService {
	mock := &MockSiteInfoCommonService{ctrl: ctrl}
	mock.recorder = &MockSiteInfoCommonServiceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockSiteInfoCommonService) EXPECT() *MockSiteInfoCommonServiceMockRecorder {
	return m.recorder
}

// FormatAvatar mocks base method.
func (m *MockSiteInfoCommonService) FormatAvatar(ctx context.Context, originalAvatarData, email string, userStatus int) *schema.AvatarInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FormatAvatar", ctx, originalAvatarData, email, userStatus)
	ret0, _ := ret[0].(*schema.AvatarInfo)
	return ret0
}

// FormatAvatar indicates an expected call of FormatAvatar.
func (mr *MockSiteInfoCommonServiceMockRecorder) FormatAvatar(ctx, originalAvatarData, email, userStatus any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FormatAvatar", reflect.TypeOf((*MockSiteInfoCommonService)(nil).FormatAvatar), ctx, originalAvatarData, email, userStatus)
}

// FormatListAvatar mocks base method.
func (m *MockSiteInfoCommonService) FormatListAvatar(ctx context.Context, userList []*entity.User) map[string]*schema.AvatarInfo {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FormatListAvatar", ctx, userList)
	ret0, _ := ret[0].(map[string]*schema.AvatarInfo)
	return ret0
}

// FormatListAvatar indicates an expected call of FormatListAvatar.
func (mr *MockSiteInfoCommonServiceMockRecorder) FormatListAvatar(ctx, userList any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FormatListAvatar", reflect.TypeOf((*MockSiteInfoCommonService)(nil).FormatListAvatar), ctx, userList)
}

// GetSiteBranding mocks base method.
func (m *MockSiteInfoCommonService) GetSiteBranding(ctx context.Context) (*schema.SiteBrandingResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteBranding", ctx)
	ret0, _ := ret[0].(*schema.SiteBrandingResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSiteBranding indicates an expected call of GetSiteBranding.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteBranding(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteBranding", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteBranding), ctx)
}

// GetSiteCustomCssHTML mocks base method.
func (m *MockSiteInfoCommonService) GetSiteCustomCssHTML(ctx context.Context) (*schema.SiteCustomCssHTMLResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteCustomCssHTML", ctx)
	ret0, _ := ret[0].(*schema.SiteCustomCssHTMLResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSiteCustomCssHTML indicates an expected call of GetSiteCustomCssHTML.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteCustomCssHTML(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteCustomCssHTML", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteCustomCssHTML), ctx)
}

// GetSiteGeneral mocks base method.
func (m *MockSiteInfoCommonService) GetSiteGeneral(ctx context.Context) (*schema.SiteGeneralResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteGeneral", ctx)
	ret0, _ := ret[0].(*schema.SiteGeneralResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSiteGeneral indicates an expected call of GetSiteGeneral.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteGeneral(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteGeneral", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteGeneral), ctx)
}

// GetSiteInfoByType mocks base method.
func (m *MockSiteInfoCommonService) GetSiteInfoByType(ctx context.Context, siteType string, resp any) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteInfoByType", ctx, siteType, resp)
	ret0, _ := ret[0].(error)
	return ret0
}

// GetSiteInfoByType indicates an expected call of GetSiteInfoByType.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteInfoByType(ctx, siteType, resp any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteInfoByType", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteInfoByType), ctx, siteType, resp)
}

// GetSiteInterface mocks base method.
func (m *MockSiteInfoCommonService) GetSiteInterface(ctx context.Context) (*schema.SiteInterfaceResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteInterface", ctx)
	ret0, _ := ret[0].(*schema.SiteInterfaceResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSiteInterface indicates an expected call of GetSiteInterface.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteInterface(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteInterface", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteInterface), ctx)
}

// GetSiteLegal mocks base method.
func (m *MockSiteInfoCommonService) GetSiteLegal(ctx context.Context) (*schema.SiteLegalResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteLegal", ctx)
	ret0, _ := ret[0].(*schema.SiteLegalResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSiteLegal indicates an expected call of GetSiteLegal.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteLegal(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteLegal", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteLegal), ctx)
}

// GetSiteLogin mocks base method.
func (m *MockSiteInfoCommonService) GetSiteLogin(ctx context.Context) (*schema.SiteLoginResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteLogin", ctx)
	ret0, _ := ret[0].(*schema.SiteLoginResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSiteLogin indicates an expected call of GetSiteLogin.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteLogin(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteLogin", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteLogin), ctx)
}

// GetSiteSeo mocks base method.
func (m *MockSiteInfoCommonService) GetSiteSeo(ctx context.Context) (*schema.SiteSeoResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteSeo", ctx)
	ret0, _ := ret[0].(*schema.SiteSeoResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSiteSeo indicates an expected call of GetSiteSeo.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteSeo(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteSeo", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteSeo), ctx)
}

// GetSiteTheme mocks base method.
func (m *MockSiteInfoCommonService) GetSiteTheme(ctx context.Context) (*schema.SiteThemeResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteTheme", ctx)
	ret0, _ := ret[0].(*schema.SiteThemeResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSiteTheme indicates an expected call of GetSiteTheme.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteTheme(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteTheme", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteTheme), ctx)
}

// GetSiteUsers mocks base method.
func (m *MockSiteInfoCommonService) GetSiteUsers(ctx context.Context) (*schema.SiteUsersResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteUsers", ctx)
	ret0, _ := ret[0].(*schema.SiteUsersResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSiteUsers indicates an expected call of GetSiteUsers.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteUsers(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteUsers", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteUsers), ctx)
}

// GetSiteWrite mocks base method.
func (m *MockSiteInfoCommonService) GetSiteWrite(ctx context.Context) (*schema.SiteWriteResp, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetSiteWrite", ctx)
	ret0, _ := ret[0].(*schema.SiteWriteResp)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetSiteWrite indicates an expected call of GetSiteWrite.
func (mr *MockSiteInfoCommonServiceMockRecorder) GetSiteWrite(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetSiteWrite", reflect.TypeOf((*MockSiteInfoCommonService)(nil).GetSiteWrite), ctx)
}

// IsBrandingFileUsed mocks base method.
func (m *MockSiteInfoCommonService) IsBrandingFileUsed(ctx context.Context, filePath string) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsBrandingFileUsed", ctx, filePath)
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsBrandingFileUsed indicates an expected call of IsBrandingFileUsed.
func (mr *MockSiteInfoCommonServiceMockRecorder) IsBrandingFileUsed(ctx, filePath any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsBrandingFileUsed", reflect.TypeOf((*MockSiteInfoCommonService)(nil).IsBrandingFileUsed), ctx, filePath)
}
