/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.SchemaElement;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Difference;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class ViewMetadata
implements SchemaElement {
    public final TableId baseTableId;
    public final String baseTableName;
    public final boolean includeAllColumns;
    public final TableMetadata metadata;
    public final WhereClause whereClause;

    public ViewMetadata(TableId baseTableId, String baseTableName, boolean includeAllColumns, WhereClause whereClause, TableMetadata metadata) {
        this.baseTableId = baseTableId;
        this.baseTableName = baseTableName;
        this.includeAllColumns = includeAllColumns;
        this.whereClause = whereClause;
        this.metadata = metadata;
    }

    public String keyspace() {
        return this.metadata.keyspace;
    }

    public String name() {
        return this.metadata.name;
    }

    public boolean includes(ColumnIdentifier column) {
        return this.metadata.getColumn(column) != null;
    }

    public ViewMetadata copy(TableMetadata newMetadata) {
        return new ViewMetadata(this.baseTableId, this.baseTableName, this.includeAllColumns, this.whereClause, newMetadata);
    }

    public TableMetadata baseTableMetadata() {
        return Schema.instance.getTableMetadata(this.baseTableId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ViewMetadata)) {
            return false;
        }
        ViewMetadata other = (ViewMetadata)o;
        return this.baseTableId.equals(other.baseTableId) && this.includeAllColumns == other.includeAllColumns && this.whereClause.equals(other.whereClause) && this.metadata.equals(other.metadata);
    }

    Optional<Difference> compare(ViewMetadata other) {
        if (!this.baseTableId.equals(other.baseTableId) || this.includeAllColumns != other.includeAllColumns || !this.whereClause.equals(other.whereClause)) {
            return Optional.of(Difference.SHALLOW);
        }
        return this.metadata.compare(other.metadata);
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.baseTableId).append(this.includeAllColumns).append((Object)this.whereClause).append((Object)this.metadata).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("baseTableId", (Object)this.baseTableId).append("baseTableName", (Object)this.baseTableName).append("includeAllColumns", this.includeAllColumns).append("whereClause", (Object)this.whereClause).append("metadata", (Object)this.metadata).toString();
    }

    public boolean referencesUserType(ByteBuffer name) {
        return this.metadata.referencesUserType(name);
    }

    public ViewMetadata withUpdatedUserType(UserType udt) {
        return this.referencesUserType(udt.name) ? this.copy(this.metadata.withUpdatedUserType(udt)) : this;
    }

    public ViewMetadata withRenamedPrimaryKeyColumn(ColumnIdentifier from, ColumnIdentifier to) {
        return new ViewMetadata(this.baseTableId, this.baseTableName, this.includeAllColumns, this.whereClause.renameIdentifier(from, to), this.metadata.unbuild().renamePrimaryKeyColumn(from, to).build());
    }

    public ViewMetadata withAddedRegularColumn(ColumnMetadata column) {
        return new ViewMetadata(this.baseTableId, this.baseTableName, this.includeAllColumns, this.whereClause, this.metadata.unbuild().addColumn(column).build());
    }

    public void appendCqlTo(CqlBuilder builder, boolean internals, boolean ifNotExists) {
        builder.append("CREATE MATERIALIZED VIEW ");
        if (ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(this.metadata.toString()).append(" AS").newLine().increaseIndent().append("SELECT ");
        if (this.includeAllColumns) {
            builder.append('*');
        } else {
            builder.appendWithSeparators(this.metadata.allColumnsInSelectOrder(), (b, c) -> b.append(c.name), ", ");
        }
        builder.newLine().append("FROM ").appendQuotingIfNeeded(this.metadata.keyspace).append('.').appendQuotingIfNeeded(this.baseTableName).newLine().append("WHERE ").append(this.whereClause.toString()).newLine();
        this.metadata.appendPrimaryKey(builder);
        builder.decreaseIndent().append(" WITH ").increaseIndent();
        this.metadata.appendTableOptions(builder, internals);
    }

    @Override
    public SchemaElement.SchemaElementType elementType() {
        return SchemaElement.SchemaElementType.MATERIALIZED_VIEW;
    }

    @Override
    public String elementKeyspace() {
        return this.keyspace();
    }

    @Override
    public String elementName() {
        return this.name();
    }

    @Override
    public String toCqlString(boolean withInternals, boolean ifNotExists) {
        CqlBuilder builder = new CqlBuilder(2048);
        this.appendCqlTo(builder, withInternals, ifNotExists);
        return builder.toString();
    }
}

