/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpEcPrivateKey;
import com.amazon.corretto.crypto.provider.EvpEcPublicKey;
import com.amazon.corretto.crypto.provider.EvpKey;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.EvpRsaPrivateCrtKey;
import com.amazon.corretto.crypto.provider.EvpRsaPrivateKey;
import com.amazon.corretto.crypto.provider.EvpRsaPublicKey;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import com.amazon.corretto.crypto.provider.Loader;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

abstract class EvpKeyFactory
extends KeyFactorySpi {
    private final EvpKeyType type;
    private final AmazonCorrettoCryptoProvider provider;

    private static native long pkcs82Evp(byte[] var0, int var1, boolean var2) throws InvalidKeySpecException;

    private static native long x5092Evp(byte[] var0, int var1) throws InvalidKeySpecException;

    private static native long rsa2Evp(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, boolean var8);

    private static native long ec2Evp(byte[] var0, byte[] var1, byte[] var2, byte[] var3, boolean var4) throws InvalidKeySpecException;

    protected EvpKeyFactory(EvpKeyType evpKeyType, AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
        Loader.checkNativeLibraryAvailability();
        this.type = evpKeyType;
        this.provider = amazonCorrettoCryptoProvider;
        if (this.type == null) {
            throw new NullPointerException("Null type?!");
        }
    }

    protected boolean shouldCheckPrivateKey() {
        return this.provider.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY);
    }

    protected long maybeCheckPkcs82Evp(byte[] byArray, int n) throws InvalidKeySpecException {
        return EvpKeyFactory.pkcs82Evp(byArray, n, this.shouldCheckPrivateKey());
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PKCS8EncodedKeySpec)) {
            throw new InvalidKeySpecException("Unsupported KeySpec");
        }
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
        return this.type.buildPrivateKey(this::maybeCheckPkcs82Evp, pKCS8EncodedKeySpec);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof X509EncodedKeySpec)) {
            throw new InvalidKeySpecException("Unsupported KeySpec " + keySpec.getClass());
        }
        X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
        return this.type.buildPublicKey(EvpKeyFactory::x5092Evp, x509EncodedKeySpec);
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class) && key.getFormat().equalsIgnoreCase("PKCS#8")) {
            return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(EvpKeyFactory.requireNonNullEncoding(key))));
        }
        if (clazz.isAssignableFrom(X509EncodedKeySpec.class) && key.getFormat().equalsIgnoreCase("X.509")) {
            return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(EvpKeyFactory.requireNonNullEncoding(key))));
        }
        throw new InvalidKeySpecException("Unsupported KeySpec for key format");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (!this.keyNeedsConversion(key)) {
            return key;
        }
        try {
            EvpKey evpKey;
            if (key.getFormat().equalsIgnoreCase("PKCS#8")) {
                evpKey = (EvpKey)((Object)this.engineGeneratePrivate(new PKCS8EncodedKeySpec(EvpKeyFactory.requireNonNullEncoding(key))));
            } else if (key.getFormat().equalsIgnoreCase("X.509")) {
                evpKey = (EvpKey)((Object)this.engineGeneratePublic(new X509EncodedKeySpec(EvpKeyFactory.requireNonNullEncoding(key))));
            } else {
                throw new InvalidKeyException("Cannot convert key of format " + key.getFormat());
            }
            evpKey.setEphemeral(true);
            return evpKey;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException);
        }
    }

    protected boolean keyNeedsConversion(Key key) throws InvalidKeyException {
        if (!this.type.jceName.equalsIgnoreCase(key.getAlgorithm())) {
            throw new InvalidKeyException("Incorrect key algorithm: " + key.getAlgorithm());
        }
        return !(key instanceof EvpKey);
    }

    protected static byte[] requireNonNullEncoding(Key key) throws InvalidKeySpecException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeySpecException("Cannot convert key with NULL encoding");
        }
        return byArray;
    }

    protected byte[] paramsToDer(AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.type.jceName);
            algorithmParameters.init(algorithmParameterSpec);
            return algorithmParameters.getEncoded();
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    static class EC
    extends EvpKeyFactory {
        EC(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(EvpKeyType.EC, amazonCorrettoCryptoProvider);
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ECPrivateKeySpec) {
                ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)keySpec;
                return new EvpEcPrivateKey(EvpKeyFactory.ec2Evp(eCPrivateKeySpec.getS().toByteArray(), null, null, this.paramsToDer(eCPrivateKeySpec.getParams()), this.shouldCheckPrivateKey()));
            }
            return super.engineGeneratePrivate(keySpec);
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ECPublicKeySpec) {
                ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)keySpec;
                return new EvpEcPublicKey(EvpKeyFactory.ec2Evp(null, eCPublicKeySpec.getW().getAffineX().toByteArray(), eCPublicKeySpec.getW().getAffineY().toByteArray(), this.paramsToDer(eCPublicKeySpec.getParams()), false));
            }
            return super.engineGeneratePublic(keySpec);
        }

        @Override
        protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
            if (ECPublicKeySpec.class.isAssignableFrom(clazz) && key instanceof ECPublicKey) {
                ECPublicKey eCPublicKey = (ECPublicKey)key;
                return (T)((KeySpec)clazz.cast(new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams())));
            }
            if (ECPrivateKeySpec.class.isAssignableFrom(clazz) && key instanceof ECPrivateKey) {
                ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
                return (T)((KeySpec)clazz.cast(new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams())));
            }
            return super.engineGetKeySpec(key, clazz);
        }
    }

    static class RSA
    extends EvpKeyFactory {
        RSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(EvpKeyType.RSA, amazonCorrettoCryptoProvider);
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            byte[] byArray5 = null;
            byte[] byArray6 = null;
            byte[] byArray7 = null;
            byte[] byArray8 = null;
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                byArray = rSAPrivateCrtKeySpec.getModulus().toByteArray();
                byArray2 = rSAPrivateCrtKeySpec.getPublicExponent().toByteArray();
                byArray3 = rSAPrivateCrtKeySpec.getPrivateExponent().toByteArray();
                byArray4 = rSAPrivateCrtKeySpec.getCrtCoefficient().toByteArray();
                byArray5 = rSAPrivateCrtKeySpec.getPrimeExponentP().toByteArray();
                byArray6 = rSAPrivateCrtKeySpec.getPrimeExponentQ().toByteArray();
                byArray7 = rSAPrivateCrtKeySpec.getPrimeP().toByteArray();
                byArray8 = rSAPrivateCrtKeySpec.getPrimeQ().toByteArray();
                return new EvpRsaPrivateCrtKey(EvpKeyFactory.rsa2Evp(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8, this.shouldCheckPrivateKey()));
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                byArray = rSAPrivateKeySpec.getModulus().toByteArray();
                byArray3 = rSAPrivateKeySpec.getPrivateExponent().toByteArray();
                return new EvpRsaPrivateKey(EvpKeyFactory.rsa2Evp(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8, this.shouldCheckPrivateKey()));
            }
            return super.engineGeneratePrivate(keySpec);
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                byte[] byArray = rSAPublicKeySpec.getModulus().toByteArray();
                byte[] byArray2 = rSAPublicKeySpec.getPublicExponent().toByteArray();
                return new EvpRsaPublicKey(EvpKeyFactory.rsa2Evp(byArray, byArray2, null, null, null, null, null, null, false));
            }
            return super.engineGeneratePublic(keySpec);
        }

        @Override
        protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
            if (clazz.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
                return (T)((KeySpec)clazz.cast(new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient())));
            }
            if (clazz.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
                return (T)((KeySpec)clazz.cast(new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent())));
            }
            if (clazz.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof RSAPublicKey) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
                return (T)((KeySpec)clazz.cast(new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent())));
            }
            return super.engineGetKeySpec(key, clazz);
        }
    }
}

