/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import com.google.common.collect.Lists;
import java.util.Collections;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.service.reads.DigestResolver;
import org.apache.cassandra.service.reads.repair.AbstractReadRepair;
import org.apache.cassandra.service.reads.repair.BlockingPartitionRepair;
import org.apache.cassandra.service.reads.repair.PartitionRepairEvent;
import org.apache.cassandra.service.reads.repair.ReadRepairEvent;

final class ReadRepairDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private ReadRepairDiagnostics() {
    }

    static void startRepair(AbstractReadRepair readRepair, ReplicaPlan.ForRead<?, ?> fullPlan, DigestResolver digestResolver) {
        if (service.isEnabled(ReadRepairEvent.class, ReadRepairEvent.ReadRepairEventType.START_REPAIR)) {
            service.publish(new ReadRepairEvent(ReadRepairEvent.ReadRepairEventType.START_REPAIR, readRepair, ((Endpoints)fullPlan.contacts()).endpoints(), ((Endpoints)fullPlan.readCandidates()).endpoints(), digestResolver));
        }
    }

    static void speculatedRead(AbstractReadRepair readRepair, InetAddressAndPort endpoint, ReplicaPlan.ForRead<?, ?> fullPlan) {
        if (service.isEnabled(ReadRepairEvent.class, ReadRepairEvent.ReadRepairEventType.SPECULATED_READ)) {
            service.publish(new ReadRepairEvent(ReadRepairEvent.ReadRepairEventType.SPECULATED_READ, readRepair, Collections.singletonList(endpoint), Lists.newArrayList(((Endpoints)fullPlan.readCandidates()).endpoints()), null));
        }
    }

    static void sendInitialRepair(BlockingPartitionRepair partitionRepair, InetAddressAndPort destination, Mutation mutation) {
        if (service.isEnabled(PartitionRepairEvent.class, PartitionRepairEvent.PartitionRepairEventType.SEND_INITIAL_REPAIRS)) {
            service.publish(new PartitionRepairEvent(PartitionRepairEvent.PartitionRepairEventType.SEND_INITIAL_REPAIRS, partitionRepair, destination, mutation));
        }
    }

    static void speculatedWrite(BlockingPartitionRepair partitionRepair, InetAddressAndPort destination, Mutation mutation) {
        if (service.isEnabled(PartitionRepairEvent.class, PartitionRepairEvent.PartitionRepairEventType.SPECULATED_WRITE)) {
            service.publish(new PartitionRepairEvent(PartitionRepairEvent.PartitionRepairEventType.SPECULATED_WRITE, partitionRepair, destination, mutation));
        }
    }

    static void speculatedWriteOversized(BlockingPartitionRepair partitionRepair, InetAddressAndPort destination) {
        if (service.isEnabled(PartitionRepairEvent.class, PartitionRepairEvent.PartitionRepairEventType.UPDATE_OVERSIZED)) {
            service.publish(new PartitionRepairEvent(PartitionRepairEvent.PartitionRepairEventType.UPDATE_OVERSIZED, partitionRepair, destination, null));
        }
    }
}

