/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;

public enum Compressions implements Compression
{
    Binary{

        @Override
        public byte[] compress(byte[] bytes) {
            return bytes;
        }

        @Override
        public byte[] uncompress(byte[] bytes) throws IORuntimeException {
            return bytes;
        }

        @Override
        public void compress(@NotNull BytesIn<?> from, @NotNull BytesOut<?> to) throws IllegalStateException, BufferOverflowException {
            this.copy(from, to);
        }

        @Override
        public void uncompress(@NotNull BytesIn<?> from, @NotNull BytesOut<?> to) throws IllegalStateException, BufferOverflowException {
            this.copy(from, to);
        }

        private void copy(@NotNull BytesIn<?> from, @NotNull BytesOut<?> to) throws IllegalStateException, BufferOverflowException {
            long copied = from.copyTo((BytesStore)((Object)to));
            to.writeSkip(copied);
        }

        @Override
        public InputStream decompressingStream(InputStream input) {
            return input;
        }

        @Override
        public OutputStream compressingStream(OutputStream output) {
            return output;
        }
    }
    ,
    LZW{

        @Override
        @NotNull
        public InputStream decompressingStream(@NotNull InputStream input) {
            return new InflaterInputStream(input);
        }

        @Override
        @NotNull
        public OutputStream compressingStream(@NotNull OutputStream output) {
            return new DeflaterOutputStream(output, new Deflater(-1));
        }
    }
    ,
    GZIP{

        @Override
        @NotNull
        public InputStream decompressingStream(@NotNull InputStream input) throws IORuntimeException {
            try {
                return new GZIPInputStream(input);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        @NotNull
        public OutputStream compressingStream(@NotNull OutputStream output) {
            try {
                return new GZIPOutputStream(output);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    };

}

