/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;

public class ProtocolSignature
implements Writable {
    private long version;
    private int[] methods = null;
    private static final HashMap<String, ProtocolSigFingerprint> PROTOCOL_FINGERPRINT_CACHE;

    public ProtocolSignature() {
    }

    public ProtocolSignature(long version, int[] methodHashcodes) {
        this.version = version;
        this.methods = methodHashcodes;
    }

    public long getVersion() {
        return this.version;
    }

    public int[] getMethods() {
        return this.methods;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.version = in.readLong();
        boolean hasMethods = in.readBoolean();
        if (hasMethods) {
            int numMethods = in.readInt();
            this.methods = new int[numMethods];
            for (int i = 0; i < numMethods; ++i) {
                this.methods[i] = in.readInt();
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.version);
        if (this.methods == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.methods.length);
            for (int method : this.methods) {
                out.writeInt(method);
            }
        }
    }

    static int getFingerprint(Method method) {
        int hashcode = method.getName().hashCode();
        hashcode += 31 * method.getReturnType().getName().hashCode();
        for (Class<?> type : method.getParameterTypes()) {
            hashcode = 31 * hashcode ^ type.getName().hashCode();
        }
        return hashcode;
    }

    private static int[] getFingerprints(Method[] methods) {
        if (methods == null) {
            return null;
        }
        int[] hashCodes = new int[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            hashCodes[i] = ProtocolSignature.getFingerprint(methods[i]);
        }
        return hashCodes;
    }

    static int getFingerprint(Method[] methods) {
        return ProtocolSignature.getFingerprint(ProtocolSignature.getFingerprints(methods));
    }

    static int getFingerprint(int[] hashcodes) {
        Arrays.sort(hashcodes);
        return Arrays.hashCode(hashcodes);
    }

    @VisibleForTesting
    public static void resetCache() {
        PROTOCOL_FINGERPRINT_CACHE.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProtocolSigFingerprint getSigFingerprint(Class<?> protocol, long serverVersion) {
        String protocolName = RPC.getProtocolName(protocol);
        HashMap<String, ProtocolSigFingerprint> hashMap = PROTOCOL_FINGERPRINT_CACHE;
        synchronized (hashMap) {
            ProtocolSigFingerprint sig = PROTOCOL_FINGERPRINT_CACHE.get(protocolName);
            if (sig == null) {
                int[] serverMethodHashcodes = ProtocolSignature.getFingerprints(protocol.getMethods());
                sig = new ProtocolSigFingerprint(new ProtocolSignature(serverVersion, serverMethodHashcodes), ProtocolSignature.getFingerprint(serverMethodHashcodes));
                PROTOCOL_FINGERPRINT_CACHE.put(protocolName, sig);
            }
            return sig;
        }
    }

    public static ProtocolSignature getProtocolSignature(int clientMethodsHashCode, long serverVersion, Class<? extends VersionedProtocol> protocol) {
        ProtocolSigFingerprint sig = ProtocolSignature.getSigFingerprint(protocol, serverVersion);
        if (clientMethodsHashCode == sig.fingerprint) {
            return new ProtocolSignature(serverVersion, null);
        }
        return sig.signature;
    }

    public static ProtocolSignature getProtocolSignature(String protocolName, long version) throws ClassNotFoundException {
        Class<?> protocol = Class.forName(protocolName);
        return ProtocolSignature.getSigFingerprint(protocol, version).signature;
    }

    public static ProtocolSignature getProtocolSignature(VersionedProtocol server, String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        Class<?> inter;
        try {
            inter = Class.forName(protocol);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        long serverVersion = server.getProtocolVersion(protocol, clientVersion);
        return ProtocolSignature.getProtocolSignature(clientMethodsHash, serverVersion, inter);
    }

    static {
        WritableFactories.setFactory(ProtocolSignature.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new ProtocolSignature();
            }
        });
        PROTOCOL_FINGERPRINT_CACHE = new HashMap();
    }

    private static class ProtocolSigFingerprint {
        private ProtocolSignature signature;
        private int fingerprint;

        ProtocolSigFingerprint(ProtocolSignature sig, int fingerprint) {
            this.signature = sig;
            this.fingerprint = fingerprint;
        }
    }
}

