/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import org.apache.celeborn.common.CelebornConf;

public class TransportConf {
    private final CelebornConf celebornConf;
    private final String module;

    public TransportConf(String module, CelebornConf celebornConf) {
        this.module = module;
        this.celebornConf = celebornConf;
    }

    public String getModuleName() {
        return this.module;
    }

    public String ioMode() {
        return this.celebornConf.networkIoMode(this.module);
    }

    public boolean preferDirectBufs() {
        return this.celebornConf.networkIoPreferDirectBufs(this.module);
    }

    public int connectTimeoutMs() {
        return this.celebornConf.networkIoConnectTimeoutMs(this.module);
    }

    public int connectionTimeoutMs() {
        return this.celebornConf.networkIoConnectionTimeoutMs(this.module);
    }

    public int numConnectionsPerPeer() {
        return this.celebornConf.networkIoNumConnectionsPerPeer(this.module);
    }

    public int backLog() {
        return this.celebornConf.networkIoBacklog(this.module);
    }

    public int serverThreads() {
        return this.celebornConf.networkIoServerThreads(this.module);
    }

    public int clientThreads() {
        return this.celebornConf.networkIoClientThreads(this.module);
    }

    public int receiveBuf() {
        return this.celebornConf.networkIoReceiveBuf(this.module);
    }

    public int sendBuf() {
        return this.celebornConf.networkIoSendBuf(this.module);
    }

    public int maxIORetries() {
        return this.celebornConf.networkIoMaxRetries(this.module);
    }

    public int ioRetryWaitTimeMs() {
        return this.celebornConf.networkIoRetryWaitMs(this.module);
    }

    public int memoryMapBytes() {
        return this.celebornConf.networkIoMemoryMapBytes(this.module);
    }

    public boolean lazyFileDescriptor() {
        return this.celebornConf.networkIoLazyFileDescriptor(this.module);
    }

    public boolean verboseMetrics() {
        return this.celebornConf.networkIoVerboseMetrics(this.module);
    }

    public CelebornConf getCelebornConf() {
        return this.celebornConf;
    }

    public int pushDataTimeoutCheckerThreads() {
        return this.celebornConf.pushDataTimeoutCheckerThreads(this.module);
    }

    public long pushDataTimeoutCheckIntervalMs() {
        return this.celebornConf.pushDataTimeoutCheckInterval(this.module);
    }

    public int fetchDataTimeoutCheckerThreads() {
        return this.celebornConf.fetchDataTimeoutCheckerThreads(this.module);
    }

    public long fetchDataTimeoutCheckIntervalMs() {
        return this.celebornConf.fetchDataTimeoutCheckInterval(this.module);
    }

    public long clientHeartbeatInterval() {
        return this.celebornConf.clientHeartbeatInterval(this.module);
    }
}

