/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceTypeInfo;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NMTokenPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceTypeInfoPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RegisterApplicationMasterResponsePBImpl
extends RegisterApplicationMasterResponse {
    YarnServiceProtos.RegisterApplicationMasterResponseProto proto = YarnServiceProtos.RegisterApplicationMasterResponseProto.getDefaultInstance();
    YarnServiceProtos.RegisterApplicationMasterResponseProto.Builder builder = null;
    boolean viaProto = false;
    private Resource maximumResourceCapability;
    private Map<ApplicationAccessType, String> applicationACLS = null;
    private List<Container> containersFromPreviousAttempts = null;
    private List<NMToken> nmTokens = null;
    private EnumSet<YarnServiceProtos.SchedulerResourceTypes> schedulerResourceTypes = null;
    private Map<String, Resource> profiles = null;
    private List<ResourceTypeInfo> resourceTypeInfo = null;

    public RegisterApplicationMasterResponsePBImpl() {
        this.builder = YarnServiceProtos.RegisterApplicationMasterResponseProto.newBuilder();
    }

    public RegisterApplicationMasterResponsePBImpl(YarnServiceProtos.RegisterApplicationMasterResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.RegisterApplicationMasterResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((RegisterApplicationMasterResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.maximumResourceCapability != null) {
            this.builder.setMaximumCapability(this.convertToProtoFormat(this.maximumResourceCapability));
        }
        if (this.applicationACLS != null) {
            this.addApplicationACLs();
        }
        if (this.containersFromPreviousAttempts != null) {
            this.addContainersFromPreviousAttemptToProto();
        }
        if (this.nmTokens != null) {
            this.builder.clearNmTokensFromPreviousAttempts();
            Iterable<YarnServiceProtos.NMTokenProto> iterable = this.getTokenProtoIterable(this.nmTokens);
            this.builder.addAllNmTokensFromPreviousAttempts(iterable);
        }
        if (this.schedulerResourceTypes != null) {
            this.addSchedulerResourceTypes();
        }
        if (this.profiles != null) {
            this.addResourceProfiles();
        }
        if (this.resourceTypeInfo != null) {
            this.addResourceTypeInfosToProto();
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.RegisterApplicationMasterResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public Resource getMaximumResourceCapability() {
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p;
        if (this.maximumResourceCapability != null) {
            return this.maximumResourceCapability;
        }
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder registerApplicationMasterResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasMaximumCapability()) {
            return null;
        }
        this.maximumResourceCapability = this.convertFromProtoFormat(p.getMaximumCapability());
        return this.maximumResourceCapability;
    }

    @Override
    public void setMaximumResourceCapability(Resource capability) {
        this.maybeInitBuilder();
        if (this.maximumResourceCapability == null) {
            this.builder.clearMaximumCapability();
        }
        this.maximumResourceCapability = capability;
    }

    @Override
    public Map<ApplicationAccessType, String> getApplicationACLs() {
        this.initApplicationACLs();
        return this.applicationACLS;
    }

    private void initApplicationACLs() {
        if (this.applicationACLS != null) {
            return;
        }
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationACLMapProto> list = p.getApplicationACLsList();
        this.applicationACLS = new HashMap<ApplicationAccessType, String>(list.size());
        for (YarnProtos.ApplicationACLMapProto aclProto : list) {
            this.applicationACLS.put(ProtoUtils.convertFromProtoFormat(aclProto.getAccessType()), aclProto.getAcl());
        }
    }

    private void addApplicationACLs() {
        this.maybeInitBuilder();
        this.builder.clearApplicationACLs();
        if (this.applicationACLS == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationACLMapProto> values = new Iterable<YarnProtos.ApplicationACLMapProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationACLMapProto> iterator() {
                return new Iterator<YarnProtos.ApplicationACLMapProto>(){
                    Iterator<ApplicationAccessType> aclsIterator;
                    {
                        this.aclsIterator = RegisterApplicationMasterResponsePBImpl.this.applicationACLS.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.aclsIterator.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationACLMapProto next() {
                        ApplicationAccessType key = this.aclsIterator.next();
                        return YarnProtos.ApplicationACLMapProto.newBuilder().setAcl((String)RegisterApplicationMasterResponsePBImpl.this.applicationACLS.get((Object)key)).setAccessType(ProtoUtils.convertToProtoFormat(key)).build();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationACLs((Iterable<? extends YarnProtos.ApplicationACLMapProto>)values);
    }

    @Override
    public void setApplicationACLs(Map<ApplicationAccessType, String> appACLs) {
        if (appACLs == null) {
            return;
        }
        this.initApplicationACLs();
        this.applicationACLS.clear();
        this.applicationACLS.putAll(appACLs);
    }

    @Override
    public void setClientToAMTokenMasterKey(ByteBuffer key) {
        this.maybeInitBuilder();
        if (key == null) {
            this.builder.clearClientToAmTokenMasterKey();
            return;
        }
        this.builder.setClientToAmTokenMasterKey(ByteString.copyFrom((ByteBuffer)key));
    }

    @Override
    public ByteBuffer getClientToAMTokenMasterKey() {
        this.maybeInitBuilder();
        ByteBuffer key = ByteBuffer.wrap(this.builder.getClientToAmTokenMasterKey().toByteArray());
        return key;
    }

    @Override
    public List<Container> getContainersFromPreviousAttempts() {
        if (this.containersFromPreviousAttempts != null) {
            return this.containersFromPreviousAttempts;
        }
        this.initContainersPreviousAttemptList();
        return this.containersFromPreviousAttempts;
    }

    @Override
    public void setContainersFromPreviousAttempts(List<Container> containers) {
        if (containers == null) {
            return;
        }
        this.containersFromPreviousAttempts = new ArrayList<Container>();
        this.containersFromPreviousAttempts.addAll(containers);
    }

    @Override
    public String getQueue() {
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p;
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder registerApplicationMasterResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasQueue()) {
            return null;
        }
        return p.getQueue();
    }

    @Override
    public void setQueue(String queue) {
        this.maybeInitBuilder();
        if (queue == null) {
            this.builder.clearQueue();
        } else {
            this.builder.setQueue(queue);
        }
    }

    private void initContainersPreviousAttemptList() {
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerProto> list = p.getContainersFromPreviousAttemptsList();
        this.containersFromPreviousAttempts = new ArrayList<Container>();
        for (YarnProtos.ContainerProto c : list) {
            this.containersFromPreviousAttempts.add(this.convertFromProtoFormat(c));
        }
    }

    private void addContainersFromPreviousAttemptToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainersFromPreviousAttempts();
        ArrayList<YarnProtos.ContainerProto> list = new ArrayList<YarnProtos.ContainerProto>();
        for (Container c : this.containersFromPreviousAttempts) {
            list.add(this.convertToProtoFormat(c));
        }
        this.builder.addAllContainersFromPreviousAttempts(list);
    }

    @Override
    public List<NMToken> getNMTokensFromPreviousAttempts() {
        if (this.nmTokens != null) {
            return this.nmTokens;
        }
        this.initLocalNewNMTokenList();
        return this.nmTokens;
    }

    @Override
    public void setNMTokensFromPreviousAttempts(List<NMToken> nmTokens) {
        this.maybeInitBuilder();
        if (nmTokens == null || nmTokens.isEmpty()) {
            if (this.nmTokens != null) {
                this.nmTokens.clear();
            }
            this.builder.clearNmTokensFromPreviousAttempts();
            return;
        }
        this.nmTokens = new ArrayList<NMToken>();
        this.nmTokens.addAll(nmTokens);
    }

    private synchronized void initLocalNewNMTokenList() {
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServiceProtos.NMTokenProto> list = p.getNmTokensFromPreviousAttemptsList();
        this.nmTokens = new ArrayList<NMToken>();
        for (YarnServiceProtos.NMTokenProto t : list) {
            this.nmTokens.add(this.convertFromProtoFormat(t));
        }
    }

    private synchronized Iterable<YarnServiceProtos.NMTokenProto> getTokenProtoIterable(final List<NMToken> nmTokenList) {
        this.maybeInitBuilder();
        return new Iterable<YarnServiceProtos.NMTokenProto>(){

            @Override
            public synchronized Iterator<YarnServiceProtos.NMTokenProto> iterator() {
                return new Iterator<YarnServiceProtos.NMTokenProto>(){
                    Iterator<NMToken> iter;
                    {
                        this.iter = nmTokenList.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnServiceProtos.NMTokenProto next() {
                        return RegisterApplicationMasterResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulerResourceTypes() {
        this.initSchedulerResourceTypes();
        return this.schedulerResourceTypes;
    }

    private void initSchedulerResourceTypes() {
        if (this.schedulerResourceTypes != null) {
            return;
        }
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServiceProtos.SchedulerResourceTypes> list = p.getSchedulerResourceTypesList();
        this.schedulerResourceTypes = list.isEmpty() ? EnumSet.noneOf(YarnServiceProtos.SchedulerResourceTypes.class) : EnumSet.copyOf(list);
    }

    private void addSchedulerResourceTypes() {
        this.maybeInitBuilder();
        this.builder.clearSchedulerResourceTypes();
        if (this.schedulerResourceTypes == null) {
            return;
        }
        Iterable<YarnServiceProtos.SchedulerResourceTypes> values = new Iterable<YarnServiceProtos.SchedulerResourceTypes>(){

            @Override
            public Iterator<YarnServiceProtos.SchedulerResourceTypes> iterator() {
                return new Iterator<YarnServiceProtos.SchedulerResourceTypes>(){
                    Iterator<YarnServiceProtos.SchedulerResourceTypes> settingsIterator;
                    {
                        this.settingsIterator = RegisterApplicationMasterResponsePBImpl.this.schedulerResourceTypes.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.settingsIterator.hasNext();
                    }

                    @Override
                    public YarnServiceProtos.SchedulerResourceTypes next() {
                        return this.settingsIterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllSchedulerResourceTypes((Iterable<? extends YarnServiceProtos.SchedulerResourceTypes>)values);
    }

    @Override
    public void setSchedulerResourceTypes(EnumSet<YarnServiceProtos.SchedulerResourceTypes> types) {
        if (types == null) {
            return;
        }
        this.initSchedulerResourceTypes();
        this.schedulerResourceTypes.clear();
        this.schedulerResourceTypes.addAll(types);
    }

    private void addResourceProfiles() {
        this.maybeInitBuilder();
        this.builder.clearResourceProfiles();
        if (this.profiles == null) {
            return;
        }
        YarnProtos.ResourceProfilesProto.Builder profilesBuilder = YarnProtos.ResourceProfilesProto.newBuilder();
        for (Map.Entry<String, Resource> entry : this.profiles.entrySet()) {
            YarnProtos.ResourceProfileEntry.Builder entryBuilder = YarnProtos.ResourceProfileEntry.newBuilder();
            entryBuilder.setName(entry.getKey());
            entryBuilder.setResources(this.convertToProtoFormat(entry.getValue()));
            profilesBuilder.addResourceProfilesMap(entryBuilder.build());
        }
        this.builder.setResourceProfiles(profilesBuilder.build());
    }

    private void initResourceProfiles() {
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p;
        if (this.profiles != null) {
            return;
        }
        this.profiles = new HashMap<String, Resource>();
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder registerApplicationMasterResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (p.hasResourceProfiles()) {
            YarnProtos.ResourceProfilesProto profilesProto = p.getResourceProfiles();
            for (YarnProtos.ResourceProfileEntry entry : profilesProto.getResourceProfilesMapList()) {
                this.profiles.put(entry.getName(), this.convertFromProtoFormat(entry.getResources()));
            }
        }
    }

    @Override
    public Map<String, Resource> getResourceProfiles() {
        this.initResourceProfiles();
        return this.profiles;
    }

    @Override
    public void setResourceProfiles(Map<String, Resource> profilesMap) {
        if (profilesMap == null) {
            return;
        }
        this.initResourceProfiles();
        this.profiles.clear();
        this.profiles.putAll(profilesMap);
    }

    private Resource convertFromProtoFormat(YarnProtos.ResourceProto resource) {
        return new ResourcePBImpl(resource);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource resource) {
        return ProtoUtils.convertToProtoFormat(resource);
    }

    private ContainerPBImpl convertFromProtoFormat(YarnProtos.ContainerProto p) {
        return new ContainerPBImpl(p);
    }

    private YarnProtos.ContainerProto convertToProtoFormat(Container t) {
        return ((ContainerPBImpl)t).getProto();
    }

    private YarnServiceProtos.NMTokenProto convertToProtoFormat(NMToken token) {
        return ((NMTokenPBImpl)token).getProto();
    }

    private NMToken convertFromProtoFormat(YarnServiceProtos.NMTokenProto proto) {
        return new NMTokenPBImpl(proto);
    }

    private ResourceTypeInfoPBImpl convertFromProtoFormat(YarnProtos.ResourceTypeInfoProto p) {
        return new ResourceTypeInfoPBImpl(p);
    }

    private YarnProtos.ResourceTypeInfoProto convertToProtoFormat(ResourceTypeInfo t) {
        return ((ResourceTypeInfoPBImpl)t).getProto();
    }

    @Override
    public List<ResourceTypeInfo> getResourceTypes() {
        this.initResourceTypeInfosList();
        return this.resourceTypeInfo;
    }

    @Override
    public void setResourceTypes(List<ResourceTypeInfo> types) {
        if (this.resourceTypeInfo == null) {
            this.builder.clearResourceTypes();
        }
        this.resourceTypeInfo = types;
    }

    private void addResourceTypeInfosToProto() {
        this.maybeInitBuilder();
        this.builder.clearResourceTypes();
        if (this.resourceTypeInfo == null) {
            return;
        }
        Iterable<YarnProtos.ResourceTypeInfoProto> iterable = new Iterable<YarnProtos.ResourceTypeInfoProto>(){

            @Override
            public Iterator<YarnProtos.ResourceTypeInfoProto> iterator() {
                return new Iterator<YarnProtos.ResourceTypeInfoProto>(){
                    Iterator<ResourceTypeInfo> iter;
                    {
                        this.iter = RegisterApplicationMasterResponsePBImpl.this.resourceTypeInfo.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ResourceTypeInfoProto next() {
                        return RegisterApplicationMasterResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllResourceTypes((Iterable<? extends YarnProtos.ResourceTypeInfoProto>)iterable);
    }

    private void initResourceTypeInfosList() {
        if (this.resourceTypeInfo != null) {
            return;
        }
        YarnServiceProtos.RegisterApplicationMasterResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ResourceTypeInfoProto> list = p.getResourceTypesList();
        this.resourceTypeInfo = new ArrayList<ResourceTypeInfo>();
        for (YarnProtos.ResourceTypeInfoProto a : list) {
            this.resourceTypeInfo.add(this.convertFromProtoFormat(a));
        }
    }
}

