/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.core;

import junit.framework.TestSuite;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.test.BaseJellyTest;

public class TestSwitchTag
extends BaseJellyTest {
    public TestSwitchTag(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestSwitchTag.class);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSimpleSwitch() throws Exception {
        this.setUpScript("testSwitchTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("switch.on.a", (Object)"two");
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestSwitchTag.assertNull((String)"should not have 'a.one' variable set", (Object)this.getJellyContext().getVariable("a.one"));
        TestSwitchTag.assertTrue((String)"should have set 'a.two' variable to 'true'", (boolean)this.getJellyContext().getVariable("a.two").equals("true"));
        TestSwitchTag.assertNull((String)"should not have 'a.three' variable set", (Object)this.getJellyContext().getVariable("a.three"));
        TestSwitchTag.assertNull((String)"should not have 'a.null' variable set", (Object)this.getJellyContext().getVariable("a.null"));
        TestSwitchTag.assertNull((String)"should not have 'a.default' variable set", (Object)this.getJellyContext().getVariable("a.default"));
    }

    public void testFallThru() throws Exception {
        this.setUpScript("testSwitchTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("switch.on.a", (Object)"one");
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestSwitchTag.assertTrue((String)"should have set 'a.one' variable to 'true'", (boolean)this.getJellyContext().getVariable("a.one").equals("true"));
        TestSwitchTag.assertTrue((String)"should have set 'a.two' variable to 'true'", (boolean)this.getJellyContext().getVariable("a.two").equals("true"));
        TestSwitchTag.assertNull((String)"should not have 'a.three' variable set", (Object)this.getJellyContext().getVariable("a.three"));
        TestSwitchTag.assertNull((String)"should not have 'a.null' variable set", (Object)this.getJellyContext().getVariable("a.null"));
        TestSwitchTag.assertNull((String)"should not have 'a.default' variable set", (Object)this.getJellyContext().getVariable("a.default"));
    }

    public void testDefault() throws Exception {
        this.setUpScript("testSwitchTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("switch.on.a", (Object)"negative one");
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestSwitchTag.assertNull((String)"should not have 'a.one' variable set", (Object)this.getJellyContext().getVariable("a.one"));
        TestSwitchTag.assertNull((String)"should not have 'a.two' variable set", (Object)this.getJellyContext().getVariable("a.two"));
        TestSwitchTag.assertNull((String)"should not have 'a.three' variable set", (Object)this.getJellyContext().getVariable("a.three"));
        TestSwitchTag.assertNull((String)"should not have 'a.null' variable set", (Object)this.getJellyContext().getVariable("a.null"));
        TestSwitchTag.assertTrue((String)"should have set 'a.default' variable to 'true'", (boolean)this.getJellyContext().getVariable("a.default").equals("true"));
    }

    public void testNullCase() throws Exception {
        this.setUpScript("testSwitchTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("switch.on.a", null);
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestSwitchTag.assertNull((String)"should not have 'a.one' variable set", (Object)this.getJellyContext().getVariable("a.one"));
        TestSwitchTag.assertNull((String)"should not have 'a.two' variable set", (Object)this.getJellyContext().getVariable("a.two"));
        TestSwitchTag.assertNull((String)"should not have 'a.three' variable set", (Object)this.getJellyContext().getVariable("a.three"));
        TestSwitchTag.assertTrue((String)"should have set 'a.null' variable to 'true'", (boolean)this.getJellyContext().getVariable("a.null").equals("true"));
        TestSwitchTag.assertNull((String)"should not have 'a.default' variable set", (Object)this.getJellyContext().getVariable("a.default"));
    }

    public void testSwitchWithoutOn() throws Exception {
        this.setUpScript("testSwitchTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("switch.without.on", (Object)new Boolean(true));
        try {
            script.run(this.getJellyContext(), this.getXMLOutput());
            TestSwitchTag.fail((String)"Expected MissingAttributeException");
        }
        catch (MissingAttributeException missingAttributeException) {
            // empty catch block
        }
    }

    public void testCaseWithoutSwitch() throws Exception {
        this.setUpScript("testSwitchTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("case.without.switch", (Object)new Boolean(true));
        try {
            script.run(this.getJellyContext(), this.getXMLOutput());
            TestSwitchTag.fail((String)"Expected JellyException");
        }
        catch (JellyException jellyException) {
            // empty catch block
        }
    }

    public void testDefaultWithoutSwitch() throws Exception {
        this.setUpScript("testSwitchTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("default.without.switch", (Object)new Boolean(true));
        try {
            script.run(this.getJellyContext(), this.getXMLOutput());
            TestSwitchTag.fail((String)"Expected JellyException");
        }
        catch (JellyException jellyException) {
            // empty catch block
        }
    }

    public void testCaseWithoutValue() throws Exception {
        this.setUpScript("testSwitchTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("case.without.value", (Object)new Boolean(true));
        try {
            script.run(this.getJellyContext(), this.getXMLOutput());
            TestSwitchTag.fail((String)"Expected MissingAttributeException");
        }
        catch (MissingAttributeException missingAttributeException) {
            // empty catch block
        }
    }

    public void testMultipleDefaults() throws Exception {
        this.setUpScript("testSwitchTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("multiple.defaults", (Object)new Boolean(true));
        try {
            script.run(this.getJellyContext(), this.getXMLOutput());
            TestSwitchTag.fail((String)"Expected JellyException");
        }
        catch (JellyException jellyException) {
            // empty catch block
        }
    }

    public void testCaseAfterDefault() throws Exception {
        this.setUpScript("testSwitchTag.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("case.after.default", (Object)new Boolean(true));
        try {
            script.run(this.getJellyContext(), this.getXMLOutput());
            TestSwitchTag.fail((String)"Expected JellyException");
        }
        catch (JellyException jellyException) {
            // empty catch block
        }
    }

    public void testSeveralCall() throws Exception {
        this.setUpScript("testSeveralSwitchCall.jelly");
        Script script = this.getJelly().compileScript();
        this.getJellyContext().setVariable("var", (Object)"foo");
        script.run(this.getJellyContext(), this.getXMLOutput());
        TestSwitchTag.assertEquals((Object)"defaultdefault", (Object)this.getJellyContext().getVariable("res"));
    }
}

