/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.core.UseBeanTag;
import org.apache.commons.jelly.tags.swing.ContainerTag;
import org.apache.commons.jelly.tags.swing.Factory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentTag
extends UseBeanTag
implements ContainerTag {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$swing$ComponentTag == null ? (class$org$apache$commons$jelly$tags$swing$ComponentTag = ComponentTag.class$("org.apache.commons.jelly.tags.swing.ComponentTag")) : class$org$apache$commons$jelly$tags$swing$ComponentTag));
    private Factory factory;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$swing$ComponentTag;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$swing$ContainerTag;
    static /* synthetic */ Class class$java$awt$Point;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$lang$Integer;

    public ComponentTag() {
    }

    public ComponentTag(Factory factory) {
        this.factory = factory;
    }

    public String toString() {
        String componentName = this.getComponent().getName();
        if (componentName == null || componentName.length() == 0) {
            componentName = this.getComponent().toString();
        }
        return "ComponentTag with bean " + componentName;
    }

    public void setAction(Action action) throws JellyTagException {
        Component component = this.getComponent();
        if (component != null) {
            try {
                BeanUtils.setProperty((Object)component, (String)"action", (Object)action);
            }
            catch (IllegalAccessException e) {
                throw new JellyTagException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new JellyTagException((Throwable)e);
            }
        }
    }

    public void setFont(Font font) throws JellyTagException {
        Component component = this.getComponent();
        if (component != null) {
            try {
                BeanUtils.setProperty((Object)component, (String)"font", (Object)font);
            }
            catch (IllegalAccessException e) {
                throw new JellyTagException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new JellyTagException((Throwable)e);
            }
        }
    }

    public void setBorder(Border border) throws JellyTagException {
        Component component = this.getComponent();
        if (component != null) {
            try {
                BeanUtils.setProperty((Object)component, (String)"border", (Object)border);
            }
            catch (IllegalAccessException e) {
                throw new JellyTagException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new JellyTagException((Throwable)e);
            }
        }
    }

    public void setLayout(LayoutManager layout) throws JellyTagException {
        Component component = this.getComponent();
        if (component != null) {
            if (component instanceof RootPaneContainer) {
                RootPaneContainer rpc = (RootPaneContainer)((Object)component);
                component = rpc.getContentPane();
            }
            try {
                BeanUtils.setProperty((Object)component, (String)"layout", (Object)layout);
            }
            catch (IllegalAccessException e) {
                throw new JellyTagException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new JellyTagException((Throwable)e);
            }
        }
    }

    public void addWindowListener(WindowListener listener) throws JellyTagException {
        Component component = this.getComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            window.addWindowListener(listener);
        }
    }

    public void addFocusListener(FocusListener listener) throws JellyTagException {
        Component component = this.getComponent();
        component.addFocusListener(listener);
    }

    public void addKeyListener(KeyListener listener) throws JellyTagException {
        Component component = this.getComponent();
        component.addKeyListener(listener);
    }

    public Component getComponent() {
        Object bean = this.getBean();
        if (bean instanceof Component) {
            return (Component)bean;
        }
        return null;
    }

    public void addChild(Component component, Object constraints) throws JellyTagException {
        Object parent = this.getBean();
        if (parent instanceof JFrame && component instanceof JMenuBar) {
            JFrame frame = (JFrame)parent;
            frame.setJMenuBar((JMenuBar)component);
        } else if (parent instanceof RootPaneContainer) {
            RootPaneContainer rpc = (RootPaneContainer)parent;
            if (constraints != null) {
                rpc.getContentPane().add(component, constraints);
            } else {
                rpc.getContentPane().add(component);
            }
        } else if (parent instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)parent;
            scrollPane.setViewportView(component);
        } else if (parent instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)parent;
            if (splitPane.getOrientation() == 1) {
                if (splitPane.getTopComponent() == null) {
                    splitPane.setTopComponent(component);
                } else {
                    splitPane.setBottomComponent(component);
                }
            } else if (splitPane.getLeftComponent() == null) {
                splitPane.setLeftComponent(component);
            } else {
                splitPane.setRightComponent(component);
            }
        } else if (parent instanceof JMenuBar && component instanceof JMenu) {
            JMenuBar menuBar = (JMenuBar)parent;
            menuBar.add((JMenu)component);
        } else if (parent instanceof Container) {
            Container container = (Container)parent;
            if (constraints != null) {
                container.add(component, constraints);
            } else {
                container.add(component);
            }
        }
    }

    protected Class convertToClass(Object classObject) throws MissingAttributeException, ClassNotFoundException {
        if (classObject == null) {
            return null;
        }
        return super.convertToClass(classObject);
    }

    protected Object newInstance(Class theClass, Map attributes, XMLOutput output) throws JellyTagException {
        try {
            if (theClass != null) {
                return theClass.newInstance();
            }
            return this.factory.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    protected void processBean(String var, Object bean) throws JellyTagException {
        Component component;
        if (var != null) {
            ((TagSupport)this).context.setVariable(var, bean);
        }
        if ((component = this.getComponent()) != null) {
            ContainerTag parentTag = (ContainerTag)this.findAncestorWithClass(class$org$apache$commons$jelly$tags$swing$ContainerTag == null ? (class$org$apache$commons$jelly$tags$swing$ContainerTag = ComponentTag.class$("org.apache.commons.jelly.tags.swing.ContainerTag")) : class$org$apache$commons$jelly$tags$swing$ContainerTag);
            if (parentTag != null) {
                parentTag.addChild(component, this.getConstraint());
            } else if (var == null) {
                throw new JellyTagException("The 'var' attribute must be specified or this tag must be nested inside a JellySwing container tag like a widget or a layout");
            }
        }
    }

    protected void setBeanProperties(Object bean, Map attributes) throws JellyTagException {
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            Component component = this.getComponent();
            if (component != null) {
                if (name.equals("location")) {
                    Point p = null;
                    if (value instanceof Point) {
                        p = (Point)value;
                    } else if (value != null) {
                        p = (Point)ConvertUtils.convert((String)value.toString(), (Class)(class$java$awt$Point == null ? ComponentTag.class$("java.awt.Point") : class$java$awt$Point));
                    }
                    component.setLocation(p);
                    continue;
                }
                if (name.equals("size")) {
                    Dimension d = null;
                    if (value instanceof Dimension) {
                        d = (Dimension)value;
                    } else if (value != null) {
                        d = (Dimension)ConvertUtils.convert((String)value.toString(), (Class)(class$java$awt$Dimension == null ? ComponentTag.class$("java.awt.Dimension") : class$java$awt$Dimension));
                    }
                    component.setSize(d);
                    continue;
                }
                if (name.equalsIgnoreCase("background") || name.equalsIgnoreCase("foreground")) {
                    Color c = null;
                    if (value instanceof Color) {
                        c = (Color)value;
                    } else if (value != null) {
                        c = (Color)ConvertUtils.convert((String)value.toString(), (Class)(class$java$awt$Color == null ? ComponentTag.class$("java.awt.Color") : class$java$awt$Color));
                    }
                    if (name.equalsIgnoreCase("background")) {
                        component.setBackground(c);
                        continue;
                    }
                    component.setForeground(c);
                    continue;
                }
                if (name.equalsIgnoreCase("debugGraphicsOption") || name.equalsIgnoreCase("debugGraphics") || name.equalsIgnoreCase("debug")) {
                    Integer v = null;
                    v = !(value instanceof Integer) ? (Integer)ConvertUtils.convert((String)value.toString(), (Class)(class$java$lang$Integer == null ? ComponentTag.class$("java.lang.Integer") : class$java$lang$Integer)) : (Integer)value;
                    if (!(component instanceof JComponent)) {
                        throw new IllegalArgumentException("DebugGraphics can only be set on a JComponent subclass.");
                    }
                    ((JComponent)component).setDebugGraphicsOptions(v);
                    continue;
                }
                try {
                    BeanUtils.setProperty((Object)component, (String)name, value);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new JellyTagException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new JellyTagException((Throwable)e);
                }
            }
            try {
                BeanUtils.setProperty((Object)bean, (String)name, value);
            }
            catch (IllegalAccessException e) {
                throw new JellyTagException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new JellyTagException((Throwable)e);
            }
        }
    }

    protected Object getConstraint() {
        return null;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        super.doTag(output);
        this.clearBean();
    }

    protected void clearBean() {
        this.setBean(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

