/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.junit;

import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.junit.AssertTagSupport;
import org.apache.commons.jelly.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssertThrowsTag
extends AssertTagSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$junit$AssertThrowsTag == null ? (class$org$apache$commons$jelly$tags$junit$AssertThrowsTag = AssertThrowsTag.class$("org.apache.commons.jelly.tags.junit.AssertThrowsTag")) : class$org$apache$commons$jelly$tags$junit$AssertThrowsTag));
    private String var;
    private String expected;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$junit$AssertThrowsTag;
    static /* synthetic */ Class class$java$lang$Throwable;

    public void doTag(XMLOutput output) throws JellyTagException {
        Class throwableClass = null;
        try {
            throwableClass = this.getThrowableClass();
        }
        catch (ClassNotFoundException e) {
            throw new JellyTagException((Throwable)e);
        }
        try {
            this.invokeBody(output);
        }
        catch (Throwable t) {
            JellyException je;
            if (t instanceof JellyException && (je = (JellyException)t).getCause() != null) {
                t = je.getCause();
            }
            if (this.var != null) {
                ((TagSupport)this).context.setVariable(this.var, (Object)t);
            }
            if (throwableClass != null && !throwableClass.isAssignableFrom(t.getClass())) {
                this.fail("Unexpected exception: " + t);
            }
            return;
        }
        this.fail("No exception was thrown.");
    }

    public void setExpected(String expected) {
        this.expected = expected;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return ClassLoaderUtils.getClassLoader((ClassLoader)this.classLoader, (boolean)this.getContext().getUseContextClassLoader(), ((Object)((Object)this)).getClass());
    }

    protected Class getThrowableClass() throws ClassNotFoundException {
        if (this.expected == null) {
            return class$java$lang$Throwable == null ? (class$java$lang$Throwable = AssertThrowsTag.class$("java.lang.Throwable")) : class$java$lang$Throwable;
        }
        Class<?> throwableClass = null;
        try {
            throwableClass = this.getClassLoader().loadClass(this.expected);
        }
        catch (ClassNotFoundException e) {
            try {
                throwableClass = Thread.currentThread().getContextClassLoader().loadClass(this.expected);
            }
            catch (ClassNotFoundException e2) {
                log.warn((Object)("Could not find exception class: " + this.expected));
                throw e;
            }
        }
        if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = AssertThrowsTag.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(throwableClass)) {
            log.warn((Object)("The class: " + this.expected + " is not an Exception class."));
            return null;
        }
        return throwableClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

