/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.util.TypeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BasicTypeConverterTest {
    public void assertConversion(Object from, Class toType, Object expected) {
        boolean can = TypeUtils.canConvert((Object)from, (Class)toType);
        Assertions.assertTrue((boolean)can, (String)("Can convert: " + from.getClass() + " to " + toType));
        ArrayList<Object> result = TypeUtils.convert((Object)from, (Class)toType);
        if (result.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int j = 0; j < Array.getLength(result); ++j) {
                list.add(Array.get(result, j));
            }
            result = list;
        }
        Assertions.assertEquals((Object)expected, result, (String)("Convert: " + from.getClass() + " to " + toType));
    }

    @Test
    public void testArrayToArray() {
        this.assertConversion(new int[]{1, 2}, String[].class, Arrays.asList("1", "2"));
    }

    @Test
    public void testArrayToList() {
        this.assertConversion(new int[]{1, 2}, List.class, Arrays.asList(1, 2));
    }

    @Test
    public void testBeanUtilsConverter() {
        this.assertConversion("12", BigDecimal.class, new BigDecimal(12));
    }

    @Test
    public void testInvalidConversion() {
        Assertions.assertThrows(Exception.class, () -> TypeUtils.convert((Object)"'foo'", Date.class), (String)"Type conversion exception");
    }

    @Test
    public void testListToArray() {
        this.assertConversion(Arrays.asList(1, 2), String[].class, Arrays.asList("1", "2"));
        this.assertConversion(Arrays.asList("1", "2"), int[].class, Arrays.asList(1, 2));
    }

    @Test
    public void testNodeSetToInteger() {
        this.assertConversion(new NodeSet(){

            public List getNodes() {
                return null;
            }

            public List getPointers() {
                return null;
            }

            public List getValues() {
                return Collections.singletonList("9");
            }
        }, Integer.class, 9);
    }

    @Test
    public void testNodeSetToString() {
        this.assertConversion(new NodeSet(){

            public List getNodes() {
                return null;
            }

            public List getPointers() {
                return null;
            }

            public List getValues() {
                ArrayList<String> list = new ArrayList<String>();
                list.add("hello");
                list.add("goodbye");
                return Collections.singletonList(list);
            }
        }, String.class, "hello");
    }

    @Test
    public void testPointerToString() {
        this.assertConversion(new Pointer(){
            private static final long serialVersionUID = 1L;

            public String asPath() {
                return null;
            }

            public Object clone() {
                return null;
            }

            public int compareTo(Object o) {
                return 0;
            }

            public Object getNode() {
                return null;
            }

            public Object getRootNode() {
                return null;
            }

            public Object getValue() {
                return "value";
            }

            public void setValue(Object value) {
            }
        }, String.class, "value");
    }

    @Test
    public void testPrimitiveToString() {
        this.assertConversion(1, String.class, "1");
    }

    @Test
    public void testSingletonArrayToString() {
        this.assertConversion(new String[]{"Earth"}, String.class, "Earth");
    }

    @Test
    public void testSingletonCollectionToString() {
        this.assertConversion(Collections.singleton("Earth"), String.class, "Earth");
    }
}

