/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.stream.Stream;
import org.apache.commons.lang3.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class StringsTest {
    StringsTest() {
    }

    public static Stream<Strings> stringsFactory() {
        return Stream.of(Strings.CS, Strings.CI);
    }

    @Test
    void testBuilder() {
        Assertions.assertTrue((boolean)Strings.builder().setIgnoreCase(false).get().isCaseSensitive());
        Assertions.assertFalse((boolean)Strings.builder().setIgnoreCase(true).get().isCaseSensitive());
        Assertions.assertTrue((boolean)Strings.builder().setNullIsLess(false).get().isCaseSensitive());
        Assertions.assertTrue((boolean)Strings.builder().setNullIsLess(true).get().isCaseSensitive());
    }

    @Test
    void testBuilderDefaults() {
        Strings strings = Strings.builder().get();
        Assertions.assertTrue((boolean)strings.isCaseSensitive());
    }

    @Test
    void testCaseInsensitiveConstant() {
        Assertions.assertNotNull((Object)Strings.CI);
        Assertions.assertFalse((boolean)Strings.CI.isCaseSensitive());
    }

    @Test
    void testCaseInsensitiveStartsWithAny() {
        Assertions.assertFalse((boolean)Strings.CI.startsWithAny(null, (CharSequence[])null));
        Assertions.assertFalse((boolean)Strings.CI.startsWithAny(null, new CharSequence[]{"aBc"}));
        Assertions.assertFalse((boolean)Strings.CI.startsWithAny((CharSequence)"AbCxYz", (CharSequence[])null));
        Assertions.assertFalse((boolean)Strings.CI.startsWithAny((CharSequence)"AbCxYz", new CharSequence[0]));
        Assertions.assertTrue((boolean)Strings.CI.startsWithAny((CharSequence)"AbCxYz", new CharSequence[]{"aBc"}));
        Assertions.assertTrue((boolean)Strings.CI.startsWithAny((CharSequence)"AbCxYz", new CharSequence[]{null, "XyZ", "aBc"}));
        Assertions.assertFalse((boolean)Strings.CI.startsWithAny((CharSequence)"AbCxYz", new CharSequence[]{null, "XyZ", "aBcD"}));
        Assertions.assertTrue((boolean)Strings.CI.startsWithAny((CharSequence)"AbCxYz", new CharSequence[]{""}));
        Assertions.assertTrue((boolean)Strings.CI.startsWithAny((CharSequence)"abcxyz", new CharSequence[]{null, "XyZ", "ABCX"}));
        Assertions.assertTrue((boolean)Strings.CI.startsWithAny((CharSequence)"ABCXYZ", new CharSequence[]{null, "XyZ", "abc"}));
        Assertions.assertTrue((boolean)Strings.CI.startsWithAny((CharSequence)"AbCxYz", new CharSequence[]{new StringBuilder("XyZ"), new StringBuffer("aBc")}));
        Assertions.assertTrue((boolean)Strings.CI.startsWithAny((CharSequence)new StringBuffer("AbCxYz"), new CharSequence[]{new StringBuilder("XyZ"), new StringBuffer("abc")}));
    }

    @Test
    void testCaseSensitiveConstant() {
        Assertions.assertNotNull((Object)Strings.CS);
        Assertions.assertTrue((boolean)Strings.CS.isCaseSensitive());
    }

    @ParameterizedTest
    @MethodSource(value={"stringsFactory"})
    void testEqualsCharSequence(Strings strings) {
        CharSequence nullCharSequence = null;
        Assertions.assertTrue((boolean)strings.equals(nullCharSequence, nullCharSequence));
        Assertions.assertFalse((boolean)strings.equals(nullCharSequence, (CharSequence)""));
        Assertions.assertFalse((boolean)strings.equals((CharSequence)"", nullCharSequence));
    }

    @ParameterizedTest
    @MethodSource(value={"stringsFactory"})
    void testEqualsStrings(Strings strings) {
        String nullStr = null;
        Assertions.assertTrue((boolean)strings.equals(nullStr, nullStr));
        Assertions.assertFalse((boolean)strings.equals(nullStr, ""));
        Assertions.assertFalse((boolean)strings.equals("", nullStr));
    }
}

