/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.json.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.activemq.artemis.json.JsonArrayBuilder;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.json.impl.JsonArrayBuilderImpl;
import org.apache.activemq.artemis.json.impl.JsonObjectImpl;
import org.apache.activemq.artemis.json.impl.JsonValueImpl;

public class JsonObjectBuilderImpl
implements JsonObjectBuilder {
    private final org.apache.activemq.artemis.commons.shaded.json.JsonObjectBuilder rawObjectBuilder;

    public org.apache.activemq.artemis.commons.shaded.json.JsonObjectBuilder getRawObjectBuilder() {
        return this.rawObjectBuilder;
    }

    public JsonObjectBuilderImpl(org.apache.activemq.artemis.commons.shaded.json.JsonObjectBuilder rawObjectBuilder) {
        this.rawObjectBuilder = Objects.requireNonNull(rawObjectBuilder);
    }

    @Override
    public JsonObjectBuilder add(String name, JsonValue value) {
        if (!(value instanceof JsonValueImpl)) {
            throw new UnsupportedOperationException();
        }
        this.rawObjectBuilder.add(name, ((JsonValueImpl)value).getRawValue());
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, String value) {
        this.rawObjectBuilder.add(name, value);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, String value, JsonValue defaultValue) {
        if (value != null) {
            this.rawObjectBuilder.add(name, value);
        } else {
            this.add(name, defaultValue);
        }
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, BigInteger value) {
        this.rawObjectBuilder.add(name, value);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, BigInteger value, JsonValue defaultValue) {
        if (value != null) {
            this.rawObjectBuilder.add(name, value);
        } else {
            this.add(name, defaultValue);
        }
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, BigDecimal value) {
        this.rawObjectBuilder.add(name, value);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, BigDecimal value, JsonValue defaultValue) {
        if (value != null) {
            this.rawObjectBuilder.add(name, value);
        } else {
            this.add(name, defaultValue);
        }
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, int value) {
        this.rawObjectBuilder.add(name, value);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, long value) {
        this.rawObjectBuilder.add(name, value);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, double value) {
        this.rawObjectBuilder.add(name, value);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, boolean value) {
        this.rawObjectBuilder.add(name, value);
        return this;
    }

    @Override
    public JsonObjectBuilder addNull(String name) {
        this.rawObjectBuilder.addNull(name);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, JsonObjectBuilder builder) {
        if (!(builder instanceof JsonObjectBuilderImpl)) {
            throw new UnsupportedOperationException();
        }
        this.rawObjectBuilder.add(name, ((JsonObjectBuilderImpl)builder).getRawObjectBuilder());
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, JsonArrayBuilder builder) {
        if (!(builder instanceof JsonArrayBuilderImpl)) {
            throw new UnsupportedOperationException();
        }
        this.rawObjectBuilder.add(name, ((JsonArrayBuilderImpl)builder).getRawArrayBuilder());
        return this;
    }

    @Override
    public JsonObjectBuilder remove(String name) {
        this.rawObjectBuilder.remove(name);
        return this;
    }

    @Override
    public JsonObject build() {
        return new JsonObjectImpl(this.rawObjectBuilder.build());
    }
}

