/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.util.DiskStoreValidater;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ValidateDiskStoreCommand
extends GfshCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"validate offline-disk-store"}, help="Scan the contents of a disk store to verify that it has no errors.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public ResultModel validateDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store to be validated.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, help="Directories where data for the disk store was previously written.") String[] diskDirs, @CliOption(key={"J"}, help="Arguments passed to the Java Virtual Machine performing the compact operation on the disk store.") String[] jvmProps) {
        String validatedDirectories = DiskStoreCommandsUtils.validatedDirectories(diskDirs);
        if (validatedDirectories != null) {
            throw new IllegalArgumentException("Could not find disk-dirs: \"" + validatedDirectories + "\"");
        }
        ResultModel result = new ResultModel();
        InfoResultModel infoResult = result.addInfo();
        LogWrapper logWrapper = LogWrapper.getInstance(this.getCache());
        Process validateDiskStoreProcess = null;
        try {
            String opts;
            StringBuilder dirList = new StringBuilder();
            for (String diskDir : diskDirs) {
                dirList.append(diskDir);
                dirList.append(";");
            }
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java");
            DiskStoreCommandsUtils.configureLogging(commandList);
            if (jvmProps != null && jvmProps.length != 0) {
                commandList.addAll(Arrays.asList(jvmProps));
            }
            if ((opts = System.getenv("JAVA_OPTS")) != null) {
                commandList.add(opts);
            }
            commandList.add("-classpath");
            commandList.add(System.getProperty("java.class.path", "."));
            commandList.add(DiskStoreValidater.class.getName());
            commandList.add(diskStoreName);
            commandList.add(dirList.toString());
            ProcessBuilder procBuilder = new ProcessBuilder(commandList);
            procBuilder.redirectErrorStream(true);
            validateDiskStoreProcess = procBuilder.redirectErrorStream(true).start();
            InputStream inputStream = validateDiskStoreProcess.getInputStream();
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                 BufferedReader br = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = br.readLine()) != null) {
                    infoResult.addLine(line);
                }
            }
            validateDiskStoreProcess.waitFor(2L, TimeUnit.SECONDS);
            if (validateDiskStoreProcess.exitValue() != 0) {
                result.setStatus(Result.Status.ERROR);
            }
        }
        catch (Exception e) {
            infoResult.addLine(String.format("Error compacting disk store %s: %s", diskStoreName, e.getMessage()));
            result.setStatus(Result.Status.ERROR);
            logWrapper.warning(e.getMessage(), e);
        }
        finally {
            if (validateDiskStoreProcess != null) {
                try {
                    validateDiskStoreProcess.exitValue();
                }
                catch (IllegalThreadStateException ise) {
                    validateDiskStoreProcess.destroy();
                }
            }
        }
        return result;
    }
}

