/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.internal.execute;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.deployment.FunctionScanner;
import org.apache.geode.management.internal.utils.JarFileUtils;
import org.apache.logging.log4j.Logger;

public class FunctionToFileTracker {
    private static final Logger logger = LogService.getLogger();
    private final Map<String, List<Function<?>>> deploymentToFunctionsMap = new ConcurrentHashMap();

    public synchronized void registerFunctionsFromFile(File jarFile) throws ClassNotFoundException, IOException {
        logger.debug("Registering functions for: {}", (Object)jarFile.getName());
        LinkedList registeredFunctions = new LinkedList();
        try {
            Collection<String> functionClasses = FunctionToFileTracker.findFunctionsInThisJar(jarFile);
            String filePath = jarFile.getAbsolutePath();
            LinkedList functions = new LinkedList();
            for (String functionClass : functionClasses) {
                logger.debug("Attempting to load class: {}, from JAR file: {}", (Object)functionClass, (Object)filePath);
                try {
                    functions.addAll(this.loadFunctionFromClassName(functionClass));
                }
                catch (ClassNotFoundException | NoClassDefFoundError cnfex) {
                    logger.error("Unable to load all classes from JAR file: {}", (Object)filePath, (Object)cnfex);
                    throw cnfex;
                }
            }
            registeredFunctions.addAll(this.registerFunction(filePath, functions));
        }
        catch (IOException ioex) {
            logger.error("Exception when trying to find function classes from Jar", (Throwable)ioex);
            throw ioex;
        }
        String artifactId = JarFileUtils.toArtifactId((String)jarFile.getName());
        List<Function<?>> previouslyRegisteredFunctions = this.deploymentToFunctionsMap.remove(artifactId);
        if (!registeredFunctions.isEmpty()) {
            this.deploymentToFunctionsMap.put(artifactId, registeredFunctions);
        }
        this.unregisterUndeployedFunctions(previouslyRegisteredFunctions, registeredFunctions);
    }

    private void unregisterUndeployedFunctions(List<Function<?>> previouslyRegisteredFunctions, List<Function<?>> registeredFunctions) {
        if (previouslyRegisteredFunctions == null) {
            return;
        }
        List currentlyRegisteredFunctionIDs = registeredFunctions.stream().map(Function::getId).collect(Collectors.toList());
        previouslyRegisteredFunctions.stream().map(Function::getId).filter(functionId -> !currentlyRegisteredFunctionIDs.contains(functionId)).forEach(FunctionService::unregisterFunction);
    }

    private Collection<Function<?>> loadFunctionFromClassName(String className) throws ClassNotFoundException {
        Class<?> clazz = ClassPathLoader.getLatest().forName(className);
        return this.getRegisterableFunctionsFromClass(clazz);
    }

    private List<Function<?>> registerFunction(String jarFilePath, Collection<Function<?>> functions) {
        ArrayList registeredFunctions = new ArrayList();
        for (Function<?> function : functions) {
            FunctionService.registerFunction(function);
            logger.debug("Registering function class: {}, from JAR file: {}", (Object)function.getClass().getName(), (Object)jarFilePath);
            registeredFunctions.add(function);
        }
        return registeredFunctions;
    }

    public void unregisterFunctionsForDeployment(String jarFileName) {
        List<Function<?>> functions = this.deploymentToFunctionsMap.remove(JarFileUtils.getArtifactId((String)jarFileName));
        if (functions != null) {
            functions.stream().map(Function::getId).forEach(FunctionService::unregisterFunction);
        }
    }

    private static Collection<String> findFunctionsInThisJar(File jarFile) throws IOException {
        return new FunctionScanner().findFunctionsInJar(jarFile);
    }

    private Collection<Function<?>> getRegisterableFunctionsFromClass(Class<?> clazz) {
        ArrayList registerableFunctions;
        block8: {
            registerableFunctions = new ArrayList();
            try {
                Function<?> function;
                if (!Function.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) break block8;
                boolean registerUninitializedFunction = true;
                if (Declarable.class.isAssignableFrom(clazz)) {
                    try {
                        InternalCache cache = (InternalCache)CacheFactory.getAnyInstance();
                        List<Properties> propertiesList = cache.getDeclarableProperties(clazz.getName());
                        if (!propertiesList.isEmpty()) {
                            registerUninitializedFunction = false;
                            for (Properties properties : propertiesList) {
                                Function<?> function2 = this.newFunction(clazz, true);
                                if (function2 == null) continue;
                                ((Declarable)((Object)function2)).initialize(cache, properties);
                                ((Declarable)((Object)function2)).init(properties);
                                if (function2.getId() == null) continue;
                                registerableFunctions.add(function2);
                            }
                        }
                    }
                    catch (CacheClosedException cache) {
                        // empty catch block
                    }
                }
                if (registerUninitializedFunction && (function = this.newFunction(clazz, false)) != null && function.getId() != null) {
                    registerableFunctions.add(function);
                }
            }
            catch (Exception ex) {
                logger.error("Attempting to register function from class: {}", clazz, (Object)ex);
            }
        }
        return registerableFunctions;
    }

    private Function<?> newFunction(Class<Function<?>> clazz, boolean errorOnNoSuchMethod) {
        try {
            Constructor<Function<?>> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException nsmex) {
            if (errorOnNoSuchMethod) {
                logger.error("Zero-arg constructor is required, but not found for class: {}", (Object)clazz.getName(), (Object)nsmex);
            } else {
                logger.debug("Not registering function because it doesn't have a zero-arg constructor: {}", (Object)clazz.getName());
            }
        }
        catch (Exception ex) {
            logger.error("Error when attempting constructor for function for class: {}", (Object)clazz.getName(), (Object)ex);
        }
        return null;
    }
}

