/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan;

import java.io.DataInput;
import java.util.Arrays;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.serialization.ByteArrayDataInput;

public class EventSequenceID {
    private final String membershipID;
    private final long threadID;
    private final long sequenceID;

    public EventSequenceID(byte[] membershipID, long threadID, long sequenceID) {
        Object mbr;
        try (ByteArrayDataInput byteArrayDataInput = new ByteArrayDataInput(membershipID);){
            mbr = InternalDistributedMember.readEssentialData((DataInput)byteArrayDataInput);
        }
        catch (Exception e) {
            mbr = Arrays.toString(membershipID);
        }
        this.membershipID = mbr.toString();
        this.threadID = threadID;
        this.sequenceID = sequenceID;
    }

    public String getMembershipID() {
        return this.membershipID;
    }

    public long getThreadID() {
        return this.threadID;
    }

    public long getSequenceID() {
        return this.sequenceID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EventSequenceID)) {
            return false;
        }
        EventSequenceID obj2 = (EventSequenceID)obj;
        return this.membershipID.equals(obj2.getMembershipID()) && this.threadID == obj2.getThreadID() && this.sequenceID == obj2.getSequenceID();
    }

    public int hashCode() {
        String builder = this.membershipID + this.threadID + this.sequenceID;
        return builder.hashCode();
    }

    public String toString() {
        return "membershipID: " + this.membershipID + "; threadID: " + this.threadID + "; sequenceID: " + this.sequenceID;
    }
}

