/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;

public class InterestEvent {
    private final Object key;
    private Object value;
    private boolean isDeserialized = false;

    public InterestEvent(Object key, Object value, boolean isDeserialized) {
        this.key = key;
        this.value = value;
        this.isDeserialized = isDeserialized;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        if (this.isDeserialized || this.value == null) {
            return this.value;
        }
        try {
            this.value = CacheServerHelper.deserialize((byte[])this.value);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException deserializing value", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("ClassNotFoundException deserializing value", cnfe);
        }
        this.isDeserialized = true;
        return this.value;
    }
}

