/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.util.List;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerDispatcher;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class TableHookDispatcher
implements TableDispatcher {
    private final TableDispatcher dispatcher;

    public TableHookDispatcher(TableDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        return this.dispatcher.listTables(namespace);
    }

    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        return this.dispatcher.loadTable(ident);
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        AuthorizationUtils.checkCurrentUser(ident.namespace().level(0), PrincipalUtils.getCurrentUserName());
        Table table = this.dispatcher.createTable(ident, columns, comment, properties, partitions, distribution, sortOrders, indexes);
        OwnerDispatcher ownerManager = GravitinoEnv.getInstance().ownerDispatcher();
        if (ownerManager != null) {
            ownerManager.setOwner(ident.namespace().level(0), NameIdentifierUtil.toMetadataObject(ident, Entity.EntityType.TABLE), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return table;
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        TableChange.RenameTable lastRenameChange = null;
        List<String> locations = null;
        for (TableChange change : changes) {
            if (!(change instanceof TableChange.RenameTable)) continue;
            lastRenameChange = (TableChange.RenameTable)change;
        }
        if (lastRenameChange != null) {
            locations = AuthorizationUtils.getMetadataObjectLocation(ident, Entity.EntityType.TABLE);
        }
        Table alteredTable = this.dispatcher.alterTable(ident, changes);
        if (lastRenameChange != null) {
            AuthorizationUtils.authorizationPluginRenamePrivileges(ident, Entity.EntityType.TABLE, lastRenameChange.getNewName(), locations);
        }
        return alteredTable;
    }

    public boolean dropTable(NameIdentifier ident) {
        List<String> locations = AuthorizationUtils.getMetadataObjectLocation(ident, Entity.EntityType.TABLE);
        boolean dropped = this.dispatcher.dropTable(ident);
        AuthorizationUtils.authorizationPluginRemovePrivileges(ident, Entity.EntityType.TABLE, locations);
        return dropped;
    }

    public boolean purgeTable(NameIdentifier ident) throws UnsupportedOperationException {
        List<String> locations = AuthorizationUtils.getMetadataObjectLocation(ident, Entity.EntityType.TABLE);
        boolean purged = this.dispatcher.purgeTable(ident);
        AuthorizationUtils.authorizationPluginRemovePrivileges(ident, Entity.EntityType.TABLE, locations);
        return purged;
    }

    public boolean tableExists(NameIdentifier ident) {
        return this.dispatcher.tableExists(ident);
    }
}

