/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.SupportsRelationOperations;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.TagEntity;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.RelationalBackend;
import org.apache.gravitino.storage.relational.RelationalGarbageCollector;
import org.apache.gravitino.tag.SupportsTagOperations;
import org.apache.gravitino.utils.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationalEntityStore
implements EntityStore,
SupportsTagOperations,
SupportsRelationOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationalEntityStore.class);
    public static final ImmutableMap<String, String> RELATIONAL_BACKENDS = ImmutableMap.of((Object)"JDBCBackend", (Object)JDBCBackend.class.getCanonicalName());
    private RelationalBackend backend;
    private RelationalGarbageCollector garbageCollector;

    @Override
    public void initialize(Config config) throws RuntimeException {
        this.backend = RelationalEntityStore.createRelationalEntityBackend(config);
        this.garbageCollector = new RelationalGarbageCollector(this.backend, config);
        this.garbageCollector.start();
    }

    private static RelationalBackend createRelationalEntityBackend(Config config) {
        String backendName = config.get(Configs.ENTITY_RELATIONAL_STORE);
        String className = (String)RELATIONAL_BACKENDS.getOrDefault((Object)backendName, (Object)"JDBCBackend");
        try {
            RelationalBackend relationalBackend = (RelationalBackend)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            relationalBackend.initialize(config);
            return relationalBackend;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create and initialize RelationalBackend by name '{}'.", (Object)backendName, (Object)e);
            throw new RuntimeException("Failed to create and initialize RelationalBackend by name: " + backendName, e);
        }
    }

    @Override
    public <E extends Entity & HasIdentifier> List<E> list(Namespace namespace, Class<E> type, Entity.EntityType entityType) throws IOException {
        return this.backend.list(namespace, entityType, false);
    }

    @Override
    public <E extends Entity & HasIdentifier> List<E> list(Namespace namespace, Class<E> type, Entity.EntityType entityType, boolean allFields) throws IOException {
        return this.backend.list(namespace, entityType, allFields);
    }

    @Override
    public boolean exists(NameIdentifier ident, Entity.EntityType entityType) throws IOException {
        return this.backend.exists(ident, entityType);
    }

    @Override
    public <E extends Entity & HasIdentifier> void put(E e, boolean overwritten) throws IOException, EntityAlreadyExistsException {
        this.backend.insert(e, overwritten);
    }

    @Override
    public <E extends Entity & HasIdentifier> E update(NameIdentifier ident, Class<E> type, Entity.EntityType entityType, Function<E, E> updater) throws IOException, NoSuchEntityException, EntityAlreadyExistsException {
        return this.backend.update(ident, entityType, updater);
    }

    @Override
    public <E extends Entity & HasIdentifier> E get(NameIdentifier ident, Entity.EntityType entityType, Class<E> e) throws NoSuchEntityException, IOException {
        return this.backend.get(ident, entityType);
    }

    @Override
    public boolean delete(NameIdentifier ident, Entity.EntityType entityType, boolean cascade) throws IOException {
        try {
            return this.backend.delete(ident, entityType, cascade);
        }
        catch (NoSuchEntityException nse) {
            return false;
        }
    }

    @Override
    public <R, E extends Exception> R executeInTransaction(Executable<R, E> executable) {
        throw new UnsupportedOperationException("Unsupported operation in relational entity store.");
    }

    @Override
    public void close() throws IOException {
        this.garbageCollector.close();
        this.backend.close();
    }

    @Override
    public SupportsTagOperations tagOperations() {
        return this;
    }

    @Override
    public SupportsRelationOperations relationOperations() {
        return this;
    }

    @Override
    public List<MetadataObject> listAssociatedMetadataObjectsForTag(NameIdentifier tagIdent) throws IOException {
        return this.backend.listAssociatedMetadataObjectsForTag(tagIdent);
    }

    @Override
    public List<TagEntity> listAssociatedTagsForMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType) throws NoSuchEntityException, IOException {
        return this.backend.listAssociatedTagsForMetadataObject(objectIdent, objectType);
    }

    @Override
    public TagEntity getTagForMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier tagIdent) throws NoSuchEntityException, IOException {
        return this.backend.getTagForMetadataObject(objectIdent, objectType, tagIdent);
    }

    @Override
    public List<TagEntity> associateTagsWithMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier[] tagsToAdd, NameIdentifier[] tagsToRemove) throws NoSuchEntityException, EntityAlreadyExistsException, IOException {
        return this.backend.associateTagsWithMetadataObject(objectIdent, objectType, tagsToAdd, tagsToRemove);
    }

    @Override
    public <E extends Entity & HasIdentifier> List<E> listEntitiesByRelation(SupportsRelationOperations.Type relType, NameIdentifier nameIdentifier, Entity.EntityType identType, boolean allFields) throws IOException {
        return this.backend.listEntitiesByRelation(relType, nameIdentifier, identType, allFields);
    }

    @Override
    public void insertRelation(SupportsRelationOperations.Type relType, NameIdentifier srcIdentifier, Entity.EntityType srcType, NameIdentifier dstIdentifier, Entity.EntityType dstType, boolean override) throws IOException {
        this.backend.insertRelation(relType, srcIdentifier, srcType, dstIdentifier, dstType, true);
    }
}

