/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;
import org.apache.gravitino.trino.connector.GravitinoHandle;

public final class GravitinoTableHandle
implements ConnectorTableHandle,
GravitinoHandle<ConnectorTableHandle> {
    private final String schemaName;
    private final String tableName;
    private GravitinoHandle.HandleWrapper<ConnectorTableHandle> handleWrapper = new GravitinoHandle.HandleWrapper<Class<ConnectorTableHandle>>(ConnectorTableHandle.class);

    @JsonCreator
    public GravitinoTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="handleString") String handleString) {
        Preconditions.checkArgument((schemaName != null ? 1 : 0) != 0, (Object)"schemaName is not null");
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is not null");
        Preconditions.checkArgument((handleString != null ? 1 : 0) != 0, (Object)"handleString is not null");
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.handleWrapper = this.handleWrapper.fromJson(handleString);
    }

    public GravitinoTableHandle(String schemaName, String tableName, ConnectorTableHandle internalTableHandle) {
        Preconditions.checkArgument((schemaName != null ? 1 : 0) != 0, (Object)"schemaName is not null");
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is not null");
        Preconditions.checkArgument((internalTableHandle != null ? 1 : 0) != 0, (Object)"internalTableHandle is not null");
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.handleWrapper = new GravitinoHandle.HandleWrapper<ConnectorTableHandle>(internalTableHandle);
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @JsonProperty
    public String getHandleString() {
        return this.handleWrapper.toJson();
    }

    @Override
    public ConnectorTableHandle getInternalHandle() {
        return this.handleWrapper.getHandle();
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GravitinoTableHandle other = (GravitinoTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        return String.format("%s.%s->%s", this.schemaName, this.tableName, this.getInternalHandle().toString());
    }
}

