/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.PolicyVersionBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.PolicyVersionPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.PolicyVersionPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class PolicyVersionSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, PolicyVersionBaseSQLProvider> POLICY_VERSION_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new PolicyVersionMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new PolicyVersionH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new PolicyVersionPostgreSQLProvider());

    public static PolicyVersionBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return POLICY_VERSION_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String insertPolicyVersionOnDuplicateKeyUpdate(@Param(value="policyVersion") PolicyVersionPO policyVersionPO) {
        return PolicyVersionSQLProviderFactory.getProvider().insertPolicyVersionOnDuplicateKeyUpdate(policyVersionPO);
    }

    public static String insertPolicyVersion(@Param(value="policyVersion") PolicyVersionPO policyVersionPO) {
        return PolicyVersionSQLProviderFactory.getProvider().insertPolicyVersion(policyVersionPO);
    }

    public static String softDeletePolicyVersionByMetalakeAndPolicyName(@Param(value="metalakeName") String metalakeName, @Param(value="policyName") String policyName) {
        return PolicyVersionSQLProviderFactory.getProvider().softDeletePolicyVersionByMetalakeAndPolicyName(metalakeName, policyName);
    }

    public static String deletePolicyVersionsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return PolicyVersionSQLProviderFactory.getProvider().deletePolicyVersionsByLegacyTimeline(legacyTimeline, limit);
    }

    public static String selectPolicyVersionsByRetentionCount(@Param(value="versionRetentionCount") Long versionRetentionCount) {
        return PolicyVersionSQLProviderFactory.getProvider().selectPolicyVersionsByRetentionCount(versionRetentionCount);
    }

    public static String softDeletePolicyVersionsByRetentionLine(@Param(value="policyId") Long policyId, @Param(value="versionRetentionLine") long versionRetentionLine, @Param(value="limit") int limit) {
        return PolicyVersionSQLProviderFactory.getProvider().softDeletePolicyVersionsByRetentionLine(policyId, versionRetentionLine, limit);
    }

    public static String softDeletePolicyVersionsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return PolicyVersionSQLProviderFactory.getProvider().softDeletePolicyVersionsByMetalakeId(metalakeId);
    }

    static class PolicyVersionMySQLProvider
    extends PolicyVersionBaseSQLProvider {
        PolicyVersionMySQLProvider() {
        }
    }

    static class PolicyVersionH2Provider
    extends PolicyVersionBaseSQLProvider {
        PolicyVersionH2Provider() {
        }
    }
}

