/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase;

import static org.junit.Assert.assertEquals;

import java.util.List;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category({ MiscTests.class, SmallTests.class })
public class TestTagUtil {

  @ClassRule
  public static final HBaseClassTestRule CLASS_RULE =
    HBaseClassTestRule.forClass(TestTagUtil.class);

  @Test
  public void testCarryForwardTTLTag() throws Exception {
    // No tags so far and the TTL tag must get added to the Tags list
    long ttl = 10 * 1000;
    List<Tag> tags = TagUtil.carryForwardTTLTag(null, ttl);
    assertEquals(1, tags.size());
    Tag ttlTag = tags.get(0);
    assertEquals(TagType.TTL_TAG_TYPE, ttlTag.getType());
    assertEquals(ttl, Tag.getValueAsLong(ttlTag));
    // Already having a TTL tag in the list. So the call must remove the old tag
    long ttl2 = 30 * 1000;
    tags = TagUtil.carryForwardTTLTag(tags, ttl2);
    assertEquals(1, tags.size());
    ttlTag = tags.get(0);
    assertEquals(TagType.TTL_TAG_TYPE, ttlTag.getType());
    assertEquals(ttl2, Tag.getValueAsLong(ttlTag));
  }
}
