/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.RedisFuture;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class PipelinedRedisFuture<V>
extends CompletableFuture<V>
implements RedisFuture<V> {
    private final CountDownLatch latch = new CountDownLatch(1);

    public PipelinedRedisFuture(CompletionStage<V> completionStage) {
        this(completionStage, (V v) -> v);
    }

    public PipelinedRedisFuture(CompletionStage<V> completionStage, Function<V, V> converter) {
        completionStage.thenAccept((? super T v) -> this.complete((V)converter.apply(v))).exceptionally((Throwable throwable) -> {
            this.completeExceptionally((Throwable)throwable);
            return null;
        });
    }

    public PipelinedRedisFuture(Map<?, ? extends CompletionStage<?>> executions, Function<PipelinedRedisFuture<V>, V> converter) {
        ((CompletableFuture)CompletableFuture.allOf(executions.values().toArray(new CompletableFuture[0])).thenRun(() -> this.complete((V)converter.apply(this)))).exceptionally((T throwable) -> {
            this.completeExceptionally((Throwable)throwable);
            return null;
        });
    }

    @Override
    public boolean complete(V value) {
        boolean result = super.complete(value);
        this.latch.countDown();
        return result;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean value = super.completeExceptionally(ex);
        this.latch.countDown();
        return value;
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }
}

