/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.event.cluster;

import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.event.Event;
import java.util.function.Supplier;

public class AdaptiveRefreshTriggeredEvent
implements Event {
    private final Supplier<Partitions> partitionsSupplier;
    private final Runnable topologyRefreshScheduler;
    private final ClusterTopologyRefreshOptions.RefreshTrigger refreshTrigger;

    public AdaptiveRefreshTriggeredEvent(Supplier<Partitions> partitionsSupplier, Runnable topologyRefreshScheduler, ClusterTopologyRefreshOptions.RefreshTrigger refreshTrigger) {
        this.partitionsSupplier = partitionsSupplier;
        this.topologyRefreshScheduler = topologyRefreshScheduler;
        this.refreshTrigger = refreshTrigger;
    }

    public void scheduleRefresh() {
        this.topologyRefreshScheduler.run();
    }

    public Partitions getPartitions() {
        return this.partitionsSupplier.get();
    }

    public ClusterTopologyRefreshOptions.RefreshTrigger getRefreshTrigger() {
        return this.refreshTrigger;
    }

    public static class UncoveredSlotAdaptiveRefreshTriggeredEvent
    extends AdaptiveRefreshTriggeredEvent {
        private final int slot;

        public UncoveredSlotAdaptiveRefreshTriggeredEvent(Supplier<Partitions> partitionsSupplier, Runnable topologyRefreshScheduler, int slot) {
            super(partitionsSupplier, topologyRefreshScheduler, ClusterTopologyRefreshOptions.RefreshTrigger.UNCOVERED_SLOT);
            this.slot = slot;
        }

        public int getSlot() {
            return this.slot;
        }
    }

    public static class PersistentReconnectsAdaptiveRefreshTriggeredEvent
    extends AdaptiveRefreshTriggeredEvent {
        private final int attempt;

        public PersistentReconnectsAdaptiveRefreshTriggeredEvent(Supplier<Partitions> partitionsSupplier, Runnable topologyRefreshScheduler, int attempt) {
            super(partitionsSupplier, topologyRefreshScheduler, ClusterTopologyRefreshOptions.RefreshTrigger.PERSISTENT_RECONNECTS);
            this.attempt = attempt;
        }

        public int getAttempt() {
            return this.attempt;
        }
    }
}

