/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.components;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.lang.IgniteSystemProperties;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.thread.IgniteThread;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

public class LongJvmPauseDetector
implements IgniteComponent {
    private final IgniteLogger log = Loggers.forClass(LongJvmPauseDetector.class);
    public static final int DEFAULT_JVM_PAUSE_DETECTOR_THRESHOLD = 500;
    public static final int DFLT_JVM_PAUSE_DETECTOR_PRECISION = 50;
    public static final int DFLT_JVM_PAUSE_DETECTOR_LAST_EVENTS_COUNT = 20;
    private static final int PRECISION = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_PRECISION", 50);
    private final int threshold = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_THRESHOLD", 500);
    private static final int EVT_CNT = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_LAST_EVENTS_COUNT", 20);
    private static final boolean DISABLED = IgniteSystemProperties.getBoolean("IGNITE_JVM_PAUSE_DETECTOR_DISABLED");
    private final AtomicReference<Thread> workerRef = new AtomicReference();
    private long longPausesCnt;
    private long longPausesTotalDuration;
    private long lastWakeUpTime;
    private final long[] longPausesTimestamps = new long[EVT_CNT];
    private final long[] longPausesDurations = new long[EVT_CNT];
    private final String nodeName;

    public LongJvmPauseDetector(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        if (DISABLED) {
            this.log.debug("JVM Pause Detector is disabled", new Object[0]);
            return CompletableFutures.nullCompletedFuture();
        }
        IgniteThread worker = IgniteThreadFactory.create(this.nodeName, "jvm-pause-detector-worker", this.log, new ThreadOperation[0]).newThread(() -> {
            LongJvmPauseDetector longJvmPauseDetector = this;
            synchronized (longJvmPauseDetector) {
                this.lastWakeUpTime = System.currentTimeMillis();
            }
            this.log.debug("Detector worker has been started [thread={}]", Thread.currentThread().getName());
            try {
                while (true) {
                    Thread.sleep(PRECISION);
                    longJvmPauseDetector = this;
                    synchronized (longJvmPauseDetector) {
                        long now = System.currentTimeMillis();
                        long pause = now - (long)PRECISION - this.lastWakeUpTime;
                        if (pause >= (long)this.threshold) {
                            this.log.warn("Possible too long JVM pause [duration={}ms]", pause);
                            int next = (int)(this.longPausesCnt % (long)EVT_CNT);
                            ++this.longPausesCnt;
                            this.longPausesTotalDuration += pause;
                            this.longPausesTimestamps[next] = now;
                            this.longPausesDurations[next] = pause;
                            this.lastWakeUpTime = now;
                        } else {
                            this.lastWakeUpTime = now;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                if (this.workerRef.compareAndSet(Thread.currentThread(), null)) {
                    this.log.debug("Thread has been interrupted [thread={}]", e, Thread.currentThread().getName());
                    return;
                }
                this.log.debug("Thread has been stopped [thread={}]", Thread.currentThread().getName());
                return;
            }
        });
        if (!this.workerRef.compareAndSet(null, worker)) {
            this.log.debug("{} already started", LongJvmPauseDetector.class.getSimpleName());
            return CompletableFutures.nullCompletedFuture();
        }
        worker.setDaemon(true);
        worker.start();
        this.log.debug("{} was successfully started", LongJvmPauseDetector.class.getSimpleName());
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        Thread worker = this.workerRef.getAndSet(null);
        if (worker != null && worker.isAlive() && !worker.isInterrupted()) {
            worker.interrupt();
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public static boolean enabled() {
        return !DISABLED;
    }

    synchronized long longPausesCount() {
        return this.longPausesCnt;
    }

    synchronized long longPausesTotalDuration() {
        return this.longPausesTotalDuration;
    }

    public synchronized long getLastWakeUpTime() {
        return this.lastWakeUpTime;
    }

    synchronized Map<Long, Long> longPauseEvents() {
        TreeMap<Long, Long> evts = new TreeMap<Long, Long>();
        for (int i = 0; i < this.longPausesTimestamps.length && this.longPausesTimestamps[i] != 0L; ++i) {
            evts.put(this.longPausesTimestamps[i], this.longPausesDurations[i]);
        }
        return evts;
    }

    @Nullable
    public synchronized IgniteBiTuple<Long, Long> getLastLongPause() {
        int lastPauseIdx = (int)(((long)EVT_CNT + this.longPausesCnt - 1L) % (long)EVT_CNT);
        if (this.longPausesTimestamps[lastPauseIdx] == 0L) {
            return null;
        }
        return new IgniteBiTuple<Long, Long>(this.longPausesTimestamps[lastPauseIdx], this.longPausesDurations[lastPauseIdx]);
    }

    public long longJvmPauseThreshold() {
        return this.threshold;
    }

    public String toString() {
        return S.toString(LongJvmPauseDetector.class, this);
    }
}

