/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.hlc;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.hlc.HybridTimestamp;

public interface ClockService {
    public HybridTimestamp now();

    public HybridTimestamp current();

    public long nowLong();

    public long currentLong();

    public HybridTimestamp updateClock(HybridTimestamp var1);

    public CompletableFuture<Void> waitFor(HybridTimestamp var1);

    public long maxClockSkewMillis();

    default public boolean before(HybridTimestamp firstTimestamp, HybridTimestamp anotherTimestamp) {
        return this.compareWithClockSkew(firstTimestamp, anotherTimestamp) < 0;
    }

    default public boolean after(HybridTimestamp firstTimestamp, HybridTimestamp anotherTimestamp) {
        return this.compareWithClockSkew(firstTimestamp, anotherTimestamp) > 0;
    }

    private int compareWithClockSkew(HybridTimestamp firstTimestamp, HybridTimestamp anotherTimestamp) {
        if (firstTimestamp.getPhysical() - this.maxClockSkewMillis() <= anotherTimestamp.getPhysical() && firstTimestamp.getPhysical() + this.maxClockSkewMillis() >= anotherTimestamp.getPhysical()) {
            return 0;
        }
        return firstTimestamp.compareTo(anotherTimestamp);
    }
}

