/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.writelog.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.writelog.io.ILogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchLogReader
implements ILogReader {
    private static Logger logger = LoggerFactory.getLogger(BatchLogReader.class);
    private Iterator<ConfigPhysicalPlan> planIterator;
    private boolean fileCorrupted = false;

    BatchLogReader(ByteBuffer buffer) {
        List<ConfigPhysicalPlan> logs = this.readLogs(buffer);
        this.planIterator = logs.iterator();
    }

    private List<ConfigPhysicalPlan> readLogs(ByteBuffer buffer) {
        ArrayList<ConfigPhysicalPlan> plans = new ArrayList<ConfigPhysicalPlan>();
        while (buffer.position() != buffer.limit()) {
            try {
                plans.add(ConfigPhysicalPlan.Factory.create(buffer));
            }
            catch (IOException e) {
                logger.error("Cannot deserialize PhysicalPlans from ByteBuffer, ignore remaining logs", (Throwable)e);
                this.fileCorrupted = true;
                break;
            }
        }
        return plans;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return this.planIterator.hasNext();
    }

    @Override
    public ConfigPhysicalPlan next() {
        return this.planIterator.next();
    }

    public boolean isFileCorrupted() {
        return this.fileCorrupted;
    }
}

