/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.DeviceViewIntoPathDescriptor;

public class DeviceViewIntoNode
extends SingleChildProcessNode {
    private final DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor;

    public DeviceViewIntoNode(PlanNodeId id, DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor) {
        super(id);
        this.deviceViewIntoPathDescriptor = deviceViewIntoPathDescriptor;
    }

    public DeviceViewIntoNode(PlanNodeId id, PlanNode child, DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor) {
        super(id, child);
        this.deviceViewIntoPathDescriptor = deviceViewIntoPathDescriptor;
    }

    public DeviceViewIntoPathDescriptor getDeviceViewIntoPathDescriptor() {
        return this.deviceViewIntoPathDescriptor;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.DEVICE_VIEW_INTO;
    }

    @Override
    public PlanNode clone() {
        return new DeviceViewIntoNode(this.getPlanNodeId(), this.deviceViewIntoPathDescriptor);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ColumnHeaderConstant.selectIntoAlignByDeviceColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DEVICE_VIEW_INTO.serialize(byteBuffer);
        this.deviceViewIntoPathDescriptor.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DEVICE_VIEW_INTO.serialize(stream);
        this.deviceViewIntoPathDescriptor.serialize(stream);
    }

    public static DeviceViewIntoNode deserialize(ByteBuffer byteBuffer) {
        DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor = DeviceViewIntoPathDescriptor.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new DeviceViewIntoNode(planNodeId, deviceViewIntoPathDescriptor);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeviceViewInto(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceViewIntoNode intoNode = (DeviceViewIntoNode)o;
        return this.deviceViewIntoPathDescriptor.equals(intoNode.deviceViewIntoPathDescriptor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.deviceViewIntoPathDescriptor);
    }

    public String toString() {
        return "DeviceViewIntoNode-" + this.getPlanNodeId();
    }
}

