/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.read.SchemaQueryScanNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DevicesSchemaScanNode
extends SchemaQueryScanNode {
    private final boolean hasSgCol;
    private final SchemaFilter schemaFilter;

    public DevicesSchemaScanNode(PlanNodeId id, PartialPath path, long limit, long offset, boolean isPrefixPath, boolean hasSgCol, SchemaFilter schemaFilter, PathPatternTree scope) {
        super(id, path, limit, offset, isPrefixPath, scope);
        this.hasSgCol = hasSgCol;
        this.schemaFilter = schemaFilter;
    }

    public boolean isHasSgCol() {
        return this.hasSgCol;
    }

    public SchemaFilter getSchemaFilter() {
        return this.schemaFilter;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.DEVICES_SCHEMA_SCAN;
    }

    @Override
    public PlanNode clone() {
        return new DevicesSchemaScanNode(this.getPlanNodeId(), this.path, this.limit, this.offset, this.isPrefixPath, this.hasSgCol, this.schemaFilter, this.scope);
    }

    @Override
    public List<String> getOutputColumnNames() {
        if (this.hasSgCol) {
            return ColumnHeaderConstant.showDevicesWithSgColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
        }
        return ColumnHeaderConstant.showDevicesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DEVICES_SCHEMA_SCAN.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (ByteBuffer)byteBuffer);
        this.scope.serialize(byteBuffer);
        ReadWriteIOUtils.write((long)this.limit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.offset, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.hasSgCol, (ByteBuffer)byteBuffer);
        SchemaFilter.serialize((SchemaFilter)this.schemaFilter, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DEVICES_SCHEMA_SCAN.serialize(stream);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (OutputStream)stream);
        this.scope.serialize(stream);
        ReadWriteIOUtils.write((long)this.limit, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.offset, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.hasSgCol, (OutputStream)stream);
        SchemaFilter.serialize((SchemaFilter)this.schemaFilter, (DataOutputStream)stream);
    }

    public static DevicesSchemaScanNode deserialize(ByteBuffer byteBuffer) {
        PartialPath path;
        String fullPath = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        try {
            path = new PartialPath(fullPath);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize DevicesSchemaScanNode", e);
        }
        PathPatternTree scope = PathPatternTree.deserialize((ByteBuffer)byteBuffer);
        long limit = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long offset = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        boolean isPrefixPath = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean hasSgCol = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        SchemaFilter schemaFilter = SchemaFilter.deserialize((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new DevicesSchemaScanNode(planNodeId, path, limit, offset, isPrefixPath, hasSgCol, schemaFilter, scope);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DevicesSchemaScanNode that = (DevicesSchemaScanNode)o;
        return this.hasSgCol == that.hasSgCol && Objects.equals(this.schemaFilter, that.schemaFilter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hasSgCol, this.schemaFilter);
    }

    @Override
    public String toString() {
        return String.format("DevicesSchemaScanNode-%s[Path: %s]", this.getPlanNodeId(), this.path);
    }
}

