/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ProjectNode
extends SingleChildProcessNode {
    private final Assignments assignments;

    public ProjectNode(PlanNodeId id, PlanNode child, Assignments assignments) {
        super(id, child);
        this.assignments = assignments;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitProject(this, context);
    }

    @Override
    public PlanNode clone() {
        return new ProjectNode(this.id, null, this.assignments);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    public Assignments getAssignments() {
        return this.assignments;
    }

    public boolean isIdentity() {
        return this.assignments.isIdentity();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_PROJECT_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.assignments.getMap().size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<Symbol, Expression> entry : this.assignments.getMap().entrySet()) {
            Symbol.serialize(entry.getKey(), byteBuffer);
            Expression.serialize(entry.getValue(), byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_PROJECT_NODE.serialize(stream);
        ReadWriteIOUtils.write((int)this.assignments.getMap().size(), (OutputStream)stream);
        for (Map.Entry<Symbol, Expression> entry : this.assignments.getMap().entrySet()) {
            Symbol.serialize(entry.getKey(), stream);
            Expression.serialize(entry.getValue(), stream);
        }
    }

    public static ProjectNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        Assignments.Builder assignments = Assignments.builder();
        while (size-- > 0) {
            assignments.put(Symbol.deserialize(byteBuffer), Expression.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new ProjectNode(planNodeId, null, assignments.build());
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.assignments.getOutputs();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ProjectNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.assignments);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectNode projectNode = (ProjectNode)o;
        return Objects.equal((Object)this.assignments, (Object)projectNode.assignments);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.assignments});
    }

    public String toString() {
        return "ProjectNode-" + this.getPlanNodeId();
    }
}

