/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.StartsWithColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class StartsWith2ColumnTransformer
extends BinaryColumnTransformer {
    public StartsWith2ColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void checkType() {
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder columnBuilder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                byte[] leftBytes = leftColumn.getBinary(i).getValues();
                byte[] rightBytes = rightColumn.getBinary(i).getValues();
                columnBuilder.writeBoolean(StartsWithColumnTransformer.equalCompare(leftBytes, rightBytes, 0));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i] && !leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                byte[] leftBytes = leftColumn.getBinary(i).getValues();
                byte[] rightBytes = rightColumn.getBinary(i).getValues();
                builder.writeBoolean(StartsWithColumnTransformer.equalCompare(leftBytes, rightBytes, 0));
                continue;
            }
            builder.appendNull();
        }
    }
}

