/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.attribute.update;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.RewritableByteArrayOutputStream;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateContainer;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

@ThreadSafe
public class UpdateClearContainer
implements UpdateContainer {
    static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(UpdateClearContainer.class) + RamUsageEstimator.shallowSizeOfInstance(ConcurrentHashMap.class) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    private final Set<String> tableNames = Collections.newSetFromMap(new ConcurrentHashMap());

    public UpdateClearContainer() {
    }

    UpdateClearContainer(Set<String> tableNames) {
        this.tableNames.addAll(tableNames);
    }

    @Override
    public long updateAttribute(String tableName, String[] deviceId, Map<String, Binary> updatedAttributes) {
        return this.tableNames.add(tableName) ? RamUsageEstimator.sizeOf((String)tableName) : 0L;
    }

    @Override
    public byte[] getUpdateContent(@Nonnull AtomicInteger limitBytes, @Nonnull AtomicBoolean hasRemaining) {
        RewritableByteArrayOutputStream outputStream = new RewritableByteArrayOutputStream();
        try {
            this.serializeWithLimit(outputStream, limitBytes, hasRemaining);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    @Override
    public long invalidate(String tableName) {
        if (this.tableNames.contains(tableName)) {
            this.tableNames.remove(tableName);
            return RamUsageEstimator.sizeOf((String)tableName);
        }
        return 0L;
    }

    @Override
    public long invalidate(String[] pathNodes) {
        return 0L;
    }

    @Override
    public long invalidate(String tableName, String attributeName) {
        return 0L;
    }

    private void serializeWithLimit(RewritableByteArrayOutputStream outputStream, AtomicInteger limitBytes, AtomicBoolean hasRemaining) throws IOException {
        ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
        int setSizeOffset = outputStream.skipInt();
        int setEntryCount = 0;
        for (String tableName : this.tableNames) {
            byte[] tableBytes = tableName.getBytes(TSFileConfig.STRING_CHARSET);
            int newSize = 4 + tableBytes.length;
            if (limitBytes.get() < newSize) {
                outputStream.rewrite(setEntryCount, setSizeOffset);
                hasRemaining.set(true);
                return;
            }
            limitBytes.addAndGet(-newSize);
            ++setEntryCount;
            outputStream.writeWithLength(tableBytes);
        }
        outputStream.rewrite(this.tableNames.size(), setSizeOffset);
    }

    @Override
    public Pair<Long, Boolean> updateSelfByCommitContainer(UpdateContainer commitContainer) {
        if (!(commitContainer instanceof UpdateClearContainer)) {
            return new Pair((Object)0L, (Object)false);
        }
        AtomicLong reducedBytes = new AtomicLong(0L);
        ((UpdateClearContainer)commitContainer).getTableNames().forEach(tableName -> {
            if (this.tableNames.contains(tableName)) {
                this.tableNames.remove(tableName);
                reducedBytes.addAndGet(RamUsageEstimator.sizeOf((String)tableName));
            }
        });
        return new Pair((Object)reducedBytes.get(), (Object)this.tableNames.isEmpty());
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.tableNames.size(), (OutputStream)outputStream);
        for (String tableName : this.tableNames) {
            ReadWriteIOUtils.write((String)tableName, (OutputStream)outputStream);
        }
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            this.tableNames.add(ReadWriteIOUtils.readString((InputStream)inputStream));
        }
    }

    public Set<String> getTableNames() {
        return this.tableNames;
    }

    long ramBytesUsed() {
        return INSTANCE_SIZE + this.tableNames.stream().mapToLong(RamUsageEstimator::sizeOf).reduce(0L, Long::sum);
    }
}

