/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RegisterNodesRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=558");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=560");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=559");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15195");
    private final RequestHeader requestHeader;
    private final NodeId[] nodesToRegister;

    public RegisterNodesRequest(RequestHeader requestHeader, NodeId[] nodesToRegister) {
        this.requestHeader = requestHeader;
        this.nodesToRegister = nodesToRegister;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public NodeId[] getNodesToRegister() {
        return this.nodesToRegister;
    }

    protected RegisterNodesRequest(RegisterNodesRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((RegisterNodesRequestBuilder)b).requestHeader;
        this.nodesToRegister = ((RegisterNodesRequestBuilder)b).nodesToRegister;
    }

    public static RegisterNodesRequestBuilder<?, ?> builder() {
        return new RegisterNodesRequestBuilderImpl();
    }

    public RegisterNodesRequestBuilder<?, ?> toBuilder() {
        return new RegisterNodesRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterNodesRequest)) {
            return false;
        }
        RegisterNodesRequest other = (RegisterNodesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getNodesToRegister(), other.getNodesToRegister());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegisterNodesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodesToRegister());
        return result;
    }

    @Override
    public String toString() {
        return "RegisterNodesRequest(requestHeader=" + this.getRequestHeader() + ", nodesToRegister=" + Arrays.deepToString(this.getNodesToRegister()) + ")";
    }

    private static final class RegisterNodesRequestBuilderImpl
    extends RegisterNodesRequestBuilder<RegisterNodesRequest, RegisterNodesRequestBuilderImpl> {
        private RegisterNodesRequestBuilderImpl() {
        }

        @Override
        protected RegisterNodesRequestBuilderImpl self() {
            return this;
        }

        @Override
        public RegisterNodesRequest build() {
            return new RegisterNodesRequest(this);
        }
    }

    public static abstract class RegisterNodesRequestBuilder<C extends RegisterNodesRequest, B extends RegisterNodesRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private NodeId[] nodesToRegister;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RegisterNodesRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RegisterNodesRequest instance, RegisterNodesRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.nodesToRegister(instance.nodesToRegister);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B nodesToRegister(NodeId[] nodesToRegister) {
            this.nodesToRegister = nodesToRegister;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RegisterNodesRequest.RegisterNodesRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", nodesToRegister=" + Arrays.deepToString(this.nodesToRegister) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RegisterNodesRequest> {
        @Override
        public Class<RegisterNodesRequest> getType() {
            return RegisterNodesRequest.class;
        }

        @Override
        public RegisterNodesRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            NodeId[] nodesToRegister = decoder.readNodeIdArray("NodesToRegister");
            return new RegisterNodesRequest(requestHeader, nodesToRegister);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RegisterNodesRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeNodeIdArray("NodesToRegister", value.getNodesToRegister());
        }
    }
}

