/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupingElement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class GroupingSets
extends GroupingElement {
    private final Type type;
    private final List<List<Expression>> sets;

    public GroupingSets(Type type, List<List<Expression>> sets) {
        super(null);
        this.type = Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(sets, "sets is null");
        Preconditions.checkArgument((!sets.isEmpty() ? 1 : 0) != 0, (Object)"grouping sets cannot be empty");
        this.sets = (List)sets.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
    }

    public GroupingSets(NodeLocation location, Type type, List<List<Expression>> sets) {
        super(Objects.requireNonNull(location, "location is null"));
        this.type = Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(sets, "sets is null");
        Preconditions.checkArgument((!sets.isEmpty() ? 1 : 0) != 0, (Object)"grouping sets cannot be empty");
        this.sets = (List)sets.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
    }

    public Type getType() {
        return this.type;
    }

    public List<List<Expression>> getSets() {
        return this.sets;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.sets.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupingSets(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingSets that = (GroupingSets)o;
        return this.type == that.type && this.sets.equals(that.sets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.sets});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("sets", this.sets).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!GroupingSets.sameClass(this, other)) {
            return false;
        }
        GroupingSets that = (GroupingSets)other;
        return Objects.equals(this.sets, that.sets) && Objects.equals((Object)this.type, (Object)that.type);
    }

    public static enum Type {
        EXPLICIT,
        ROLLUP,
        CUBE;

    }
}

