/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.consensus.common.Peer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusPeerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusPeerManager.class);
    private final Set<Peer> peers = Collections.newSetFromMap(new ConcurrentHashMap());

    public PipeConsensusPeerManager(List<Peer> peers) {
        this.peers.addAll(peers);
        if (this.peers.size() != peers.size()) {
            LOGGER.warn("Duplicate peers in the input list, ignore the duplicates.");
        }
    }

    public boolean contains(Peer peer) {
        return this.peers.contains(peer);
    }

    public void addPeer(Peer peer) {
        this.peers.add(peer);
    }

    public void removePeer(Peer peer) {
        this.peers.remove(peer);
    }

    public List<Peer> getOtherPeers(Peer thisNode) {
        return (List)this.peers.stream().filter(peer -> !peer.equals(thisNode)).collect(ImmutableList.toImmutableList());
    }

    public List<Peer> getPeers() {
        return ImmutableList.copyOf(this.peers);
    }

    public void clear() {
        this.peers.clear();
    }
}

