/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.consensus.request.write.procedure.DeleteProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.procedure.UpdateProcedurePlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.procedure.store.ProcedureWAL;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureInfo.class);
    private static final String MAIN_SNAPSHOT_FILENAME = "procedure_info.bin";
    private static final String PROCEDURE_SNAPSHOT_DIR = "procedures";
    private static final String PROCEDURE_SNAPSHOT_FILE_SUFFIX = ".bin";
    private static final int PROCEDURE_LOAD_BUFFER_SIZE = 0x800000;
    private static final String PROCEDURE_WAL_SUFFIX = ".proc.wal";
    private final String OLD_PROCEDURE_WAL_DIR = CommonDescriptor.getInstance().getConfig().getProcedureWalFolder();
    private final Map<Long, Procedure<ConfigNodeProcedureEnv>> procedureMap = new ConcurrentHashMap<Long, Procedure<ConfigNodeProcedureEnv>>();
    private final AtomicLong lastProcId = new AtomicLong(-1L);
    private final ProcedureFactory procedureFactory = ProcedureFactory.getInstance();
    private final ConfigManager configManager;

    public ProcedureInfo(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public boolean isOldVersion() {
        return new File(this.OLD_PROCEDURE_WAL_DIR).exists();
    }

    public List<Procedure<ConfigNodeProcedureEnv>> oldLoad() {
        ArrayList<Procedure<ConfigNodeProcedureEnv>> procedureList = new ArrayList<Procedure<ConfigNodeProcedureEnv>>();
        try (Stream<Path> s = Files.list(Paths.get(this.OLD_PROCEDURE_WAL_DIR, new String[0]));){
            s.filter(path -> path.getFileName().toString().endsWith(PROCEDURE_WAL_SUFFIX)).sorted((p1, p2) -> Long.compareUnsigned(Long.parseLong(p1.getFileName().toString().split("\\.")[0]), Long.parseLong(p2.getFileName().toString().split("\\.")[0]))).forEach(path -> ProcedureInfo.loadProcedure(path).ifPresent(procedureList::add));
        }
        catch (IOException e) {
            LOGGER.error("Load procedure wal failed.", (Throwable)e);
        }
        procedureList.forEach(procedure -> this.procedureMap.put(procedure.getProcId(), (Procedure<ConfigNodeProcedureEnv>)procedure));
        procedureList.forEach(procedure -> this.lastProcId.set(Math.max(this.lastProcId.get(), procedure.getProcId())));
        return procedureList;
    }

    public void upgrade() {
        if (this.isOldVersion()) {
            try {
                LOGGER.info("Old procedure files have been loaded successfully, taking snapshot...");
                this.configManager.getConsensusManager().manuallyTakeSnapshot();
            }
            catch (ConsensusException e) {
                LOGGER.warn("Taking snapshot fail, procedure upgrade fail", (Throwable)e);
                return;
            }
            try {
                FileUtils.recursivelyDeleteFolder((String)this.OLD_PROCEDURE_WAL_DIR);
            }
            catch (IOException e) {
                LOGGER.error("Delete useless procedure wal dir fail.", (Throwable)e);
                LOGGER.error("You should manually delete the procedure wal dir before ConfigNode restart. {}", (Object)this.OLD_PROCEDURE_WAL_DIR);
            }
            LOGGER.info("The Procedure framework has been successfully upgraded. Now it uses the consensus layer's services instead of maintaining the WAL itself.");
        }
    }

    public TSStatus updateProcedure(UpdateProcedurePlan updateProcedurePlan) {
        Procedure<ConfigNodeProcedureEnv> procedure = updateProcedurePlan.getProcedure();
        this.procedureMap.put(procedure.getProcId(), procedure);
        this.lastProcId.updateAndGet(id -> Math.max(id, procedure.getProcId()));
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    @TestOnly
    public TSStatus oldUpdateProcedure(UpdateProcedurePlan updateProcedurePlan) {
        Procedure<ConfigNodeProcedureEnv> procedure = updateProcedurePlan.getProcedure();
        long procId = procedure.getProcId();
        Path path = Paths.get(this.OLD_PROCEDURE_WAL_DIR, procId + PROCEDURE_WAL_SUFFIX);
        ProcedureWAL procedureWAL = new ProcedureWAL(path, this.procedureFactory);
        try {
            procedureWAL.save(procedure);
        }
        catch (IOException e) {
            LOGGER.error("Update Procedure (pid={}) wal failed", (Object)procedure.getProcId(), (Object)e);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus deleteProcedure(DeleteProcedurePlan deleteProcedurePlan) {
        this.procedureMap.remove(deleteProcedurePlan.getProcId());
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Optional<Procedure> loadProcedure(Path procedureFilePath) {
        try (FileInputStream fis = new FileInputStream(procedureFilePath.toFile());){
            Optional<Object> optional;
            block15: {
                Procedure procedure = null;
                FileChannel channel = fis.getChannel();
                try {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(0x800000);
                    if (channel.read(byteBuffer) > 0) {
                        byteBuffer.flip();
                        procedure = ProcedureFactory.getInstance().create(byteBuffer);
                        byteBuffer.clear();
                    }
                    optional = Optional.ofNullable(procedure);
                    if (channel == null) break block15;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("Load {} failed, it will be deleted.", (Object)procedureFilePath, (Object)e);
            if (!procedureFilePath.toFile().delete()) {
                LOGGER.error("{} deleted failed; take appropriate action.", (Object)procedureFilePath, (Object)e);
            }
            return Optional.empty();
        }
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        File procedureSnapshotDir = new File(snapshotDir, PROCEDURE_SNAPSHOT_DIR);
        if (procedureSnapshotDir.exists()) {
            LOGGER.error("Failed to take snapshot, because snapshot dir [{}] is already exist.", (Object)procedureSnapshotDir.getAbsolutePath());
            return false;
        }
        File tmpDir = new File(procedureSnapshotDir.getAbsolutePath() + "-" + UUID.randomUUID());
        if (!tmpDir.mkdir()) {
            LOGGER.error("Failed to take snapshot, because create tmp dir [{}] fail.", (Object)tmpDir);
            return false;
        }
        File mainFile = new File(tmpDir.getAbsolutePath() + File.separator + MAIN_SNAPSHOT_FILENAME);
        try (FileOutputStream fileOutputStream = new FileOutputStream(mainFile);
             DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
             TIOStreamTransport tioStreamTransport = new TIOStreamTransport((OutputStream)fileOutputStream);){
            ReadWriteIOUtils.write((long)this.lastProcId.get(), (OutputStream)fileOutputStream);
            tioStreamTransport.flush();
            fileOutputStream.getFD().sync();
        }
        AtomicBoolean snapshotAllSuccess = new AtomicBoolean(true);
        this.procedureMap.values().forEach(procedure -> {
            try {
                new ProcedureWAL(Paths.get(tmpDir.getAbsolutePath() + File.separator + procedure.getProcId() + PROCEDURE_SNAPSHOT_FILE_SUFFIX, new String[0]), this.procedureFactory).save((Procedure)procedure);
            }
            catch (IOException e) {
                snapshotAllSuccess.set(false);
                LOGGER.warn("{} id {} took snapshot fail", new Object[]{procedure.getClass(), procedure.getProcId(), e});
            }
        });
        if (!snapshotAllSuccess.get()) {
            return false;
        }
        return tmpDir.renameTo(procedureSnapshotDir);
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File procedureSnapshotDir = new File(snapshotDir, PROCEDURE_SNAPSHOT_DIR);
        if (!procedureSnapshotDir.exists() || !procedureSnapshotDir.isDirectory()) {
            LOGGER.error("Failed to load snapshot, because snapshot dir [{}] not exists.", (Object)procedureSnapshotDir.getAbsolutePath());
            return;
        }
        File mainFile = new File(procedureSnapshotDir.getAbsolutePath() + File.separator + MAIN_SNAPSHOT_FILENAME);
        try (FileInputStream fileInputStream = new FileInputStream(mainFile);){
            this.lastProcId.set(ReadWriteIOUtils.readLong((InputStream)fileInputStream));
        }
        Arrays.stream(Objects.requireNonNull(procedureSnapshotDir.listFiles())).forEach(procedureSnapshotFile -> {
            if (!procedureSnapshotFile.getName().equals(MAIN_SNAPSHOT_FILENAME)) {
                ProcedureInfo.loadProcedure(procedureSnapshotFile.toPath()).ifPresent(procedure -> this.procedureMap.put(procedure.getProcId(), (Procedure<ConfigNodeProcedureEnv>)procedure));
            }
        });
    }

    public List<Procedure<ConfigNodeProcedureEnv>> getProcedures() {
        return new ArrayList<Procedure<ConfigNodeProcedureEnv>>(this.procedureMap.values());
    }

    public long getNextProcId() {
        return this.lastProcId.incrementAndGet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcedureInfo procedureInfo = (ProcedureInfo)o;
        return this.lastProcId.get() == procedureInfo.lastProcId.get() && this.procedureMap.equals(procedureInfo.procedureMap);
    }

    public int hashCode() {
        return Objects.hash(this.lastProcId, this.procedureMap);
    }
}

