/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class IsOverQuota
extends GenericMatcher {
    private static final int SINGLE_EMAIL = 1;
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaManager quotaManager;
    private final UsersRepository usersRepository;

    @Inject
    public IsOverQuota(QuotaRootResolver quotaRootResolver, QuotaManager quotaManager, UsersRepository usersRepository) {
        this.quotaRootResolver = quotaRootResolver;
        this.quotaManager = quotaManager;
        this.usersRepository = usersRepository;
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        try {
            ArrayList<MailAddress> result = new ArrayList<MailAddress>();
            for (MailAddress mailAddress : mail.getRecipients()) {
                Username userName = this.usersRepository.getUsername(mailAddress);
                MailboxPath mailboxPath = MailboxPath.inbox((Username)userName);
                QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(mailboxPath);
                QuotaManager.Quotas quotas = this.quotaManager.getQuotas(quotaRoot);
                if (!quotas.getMessageQuota().isOverQuotaWithAdditionalValue(1L) && !quotas.getStorageQuota().isOverQuotaWithAdditionalValue(mail.getMessageSize())) continue;
                result.add(mailAddress);
            }
            return result;
        }
        catch (MailboxException e) {
            throw new MessagingException("Exception while checking quotas", (Exception)((Object)e));
        }
        catch (UsersRepositoryException e) {
            throw new MessagingException("Exception while retrieving username", (Exception)((Object)e));
        }
    }
}

