/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import com.google.common.base.CharMatcher;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Locale;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.SectionType;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.FetchPartPathDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.FetchRequest;

public class FetchCommandParser
extends AbstractUidCommandParser {
    private static final String CHANGEDSINCE = "CHANGEDSINCE";
    private static final String VANISHED = "VANISHED";
    private static final CharMatcher CLOSING_BRACKET = CharMatcher.is((char)']');
    private static final CharMatcher NEXT_ELEMENT_END = CharMatcher.anyOf((CharSequence)" [)\r\n");

    @Inject
    public FetchCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.FETCH_COMMAND, statusResponseFactory);
    }

    private FetchData fetchRequest(ImapRequestLineReader request, boolean useUid) throws DecodingException {
        FetchData.Builder fetch = FetchData.builder();
        if (useUid) {
            fetch.fetch(FetchData.Item.UID);
        }
        char next = this.nextNonSpaceChar(request);
        if (request.nextChar() == '(') {
            request.consumeChar('(');
            next = this.nextNonSpaceChar(request);
            while (next != ')') {
                this.addNextElement(request, fetch);
                next = this.nextNonSpaceChar(request);
            }
            request.consumeChar(')');
            next = this.nextNonSpaceChar(request);
            if (next == '(') {
                request.consumeChar('(');
                while (this.parseModifier(request, fetch)) {
                    this.nextNonSpaceChar(request);
                }
                request.consumeChar(')');
            }
        } else {
            this.addNextElement(request, fetch);
        }
        return fetch.build();
    }

    private boolean parseModifier(ImapRequestLineReader request, FetchData.Builder fetch) throws DecodingException {
        char next = request.nextChar();
        switch (next) {
            case 'C': {
                request.consumeWord(ImapRequestLineReader.StringMatcherCharacterValidator.ignoreCase(CHANGEDSINCE));
                fetch.changedSince(request.number(true));
                return true;
            }
            case 'P': {
                request.consumeWord(ImapRequestLineReader.StringMatcherCharacterValidator.ignoreCase("PARTIAL"));
                fetch.partial(request.parsePartialRange());
                return true;
            }
            case 'V': {
                request.consumeWord(ImapRequestLineReader.StringMatcherCharacterValidator.ignoreCase(VANISHED), true);
                fetch.vanished(true);
                return true;
            }
        }
        return false;
    }

    private void addNextElement(ImapRequestLineReader reader, FetchData.Builder fetch) throws DecodingException {
        String name = reader.readUntil(NEXT_ELEMENT_END);
        char next = reader.nextChar();
        if (next != '[') {
            this.addNextName(fetch, name);
        } else {
            Long numberOfOctets;
            Long firstOctet;
            reader.consumeChar('[');
            String parameter = reader.readUntil(CLOSING_BRACKET);
            reader.consumeChar(']');
            if (reader.nextChar() == '<') {
                reader.consumeChar('<');
                firstOctet = reader.number();
                if (reader.nextChar() == '.') {
                    reader.consumeChar('.');
                    numberOfOctets = reader.nzNumber();
                } else {
                    numberOfOctets = null;
                }
                reader.consumeChar('>');
            } else {
                firstOctet = null;
                numberOfOctets = null;
            }
            BodyFetchElement bodyFetchElement = this.createBodyElement(parameter, firstOctet, numberOfOctets);
            boolean isPeek = this.isPeek(name);
            fetch.add(bodyFetchElement, isPeek);
        }
    }

    private FetchData.Builder addNextName(FetchData.Builder fetch, String name) throws DecodingException {
        String capitalizedName;
        switch (capitalizedName = name.toUpperCase(Locale.US)) {
            case "FAST": {
                return fetch.fetch(FetchData.Item.FLAGS, FetchData.Item.INTERNAL_DATE, FetchData.Item.SIZE);
            }
            case "FULL": {
                return fetch.fetch(FetchData.Item.FLAGS, FetchData.Item.INTERNAL_DATE, FetchData.Item.SIZE, FetchData.Item.ENVELOPE, FetchData.Item.BODY);
            }
            case "ALL": {
                return fetch.fetch(FetchData.Item.FLAGS, FetchData.Item.INTERNAL_DATE, FetchData.Item.SIZE, FetchData.Item.ENVELOPE);
            }
            case "FLAGS": {
                return fetch.fetch(FetchData.Item.FLAGS);
            }
            case "RFC822.SIZE": {
                return fetch.fetch(FetchData.Item.SIZE);
            }
            case "ENVELOPE": {
                return fetch.fetch(FetchData.Item.ENVELOPE);
            }
            case "INTERNALDATE": {
                return fetch.fetch(FetchData.Item.INTERNAL_DATE);
            }
            case "BODY": {
                return fetch.fetch(FetchData.Item.BODY);
            }
            case "BODYSTRUCTURE": {
                return fetch.fetch(FetchData.Item.BODY_STRUCTURE);
            }
            case "UID": {
                return fetch.fetch(FetchData.Item.UID);
            }
            case "RFC822": {
                return fetch.add(BodyFetchElement.createRFC822(), false);
            }
            case "RFC822.HEADER": {
                return fetch.add(BodyFetchElement.createRFC822Header(), true);
            }
            case "RFC822.TEXT": {
                return fetch.add(BodyFetchElement.createRFC822Text(), false);
            }
            case "MODSEQ": {
                return fetch.fetch(FetchData.Item.MODSEQ);
            }
            case "EMAILID": {
                return fetch.fetch(FetchData.Item.EMAILID);
            }
            case "THREADID": {
                return fetch.fetch(FetchData.Item.THREADID);
            }
            case "SAVEDATE": {
                return fetch.fetch(FetchData.Item.SAVEDATE);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid fetch attribute: " + name);
    }

    private boolean isPeek(String name) throws DecodingException {
        switch (name.toUpperCase(Locale.US)) {
            case "BODY": {
                return false;
            }
            case "BODY.PEEK": {
                return true;
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid fetch attibute: " + name + "[]");
    }

    private BodyFetchElement createBodyElement(String parameter, Long firstOctet, Long numberOfOctets) throws DecodingException {
        String responseName = "BODY[" + parameter + "]";
        FetchPartPathDecoder decoder = new FetchPartPathDecoder();
        decoder.decode(parameter);
        SectionType sectionType = decoder.getSpecifier();
        List<String> names = decoder.getNames();
        int[] path = decoder.getPath();
        return new BodyFetchElement(responseName, sectionType, path, names, firstOctet, numberOfOctets);
    }

    private char nextNonSpaceChar(ImapRequestLineReader request) throws DecodingException {
        char next = request.nextChar();
        while (next == ' ') {
            request.consume();
            next = request.nextChar();
        }
        return next;
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, boolean useUids, ImapSession session) throws DecodingException {
        IdRange[] idSet = request.parseIdRange(session);
        FetchData fetch = this.fetchRequest(request, useUids);
        if (fetch.getVanished() && !useUids) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "VANISHED only allowed in UID FETCH");
        }
        request.eol();
        return new FetchRequest(useUids, idSet, fetch, tag);
    }
}

