/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.InMemoryDirectoryServerPassword;
import com.unboundid.ldap.listener.InMemoryExtendedOperationHandler;
import com.unboundid.ldap.listener.InMemoryRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedRequest;
import com.unboundid.ldap.sdk.extensions.PasswordModifyExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadLocalSecureRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordModifyExtendedOperationHandler
extends InMemoryExtendedOperationHandler {
    @Override
    @NotNull
    public String getExtendedOperationHandlerName() {
        return "Password Modify";
    }

    @Override
    @NotNull
    public List<String> getSupportedExtendedRequestOIDs() {
        return Collections.singletonList("1.3.6.1.4.1.4203.1.11.1");
    }

    @Override
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull InMemoryRequestHandler handler, int messageID, @NotNull ExtendedRequest request) {
        ASN1OctetString genPW;
        byte[] pwBytes;
        DN targetDN;
        PasswordModifyExtendedRequest pwModRequest;
        boolean noOperation = false;
        for (Control c : request.getControls()) {
            if (c.getOID().equalsIgnoreCase("1.3.6.1.4.1.4203.1.10.2")) {
                noOperation = true;
                continue;
            }
            if (!c.isCritical()) continue;
            return new ExtendedResult(messageID, ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_PW_MOD_EXTOP_UNSUPPORTED_CONTROL.get(c.getOID()), null, null, null, null, null);
        }
        try {
            pwModRequest = new PasswordModifyExtendedRequest(request);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new ExtendedResult(messageID, le.getResultCode(), le.getDiagnosticMessage(), le.getMatchedDN(), le.getReferralURLs(), null, null, null);
        }
        String userIdentity = pwModRequest.getUserIdentity();
        byte[] oldPWBytes = pwModRequest.getOldPasswordBytes();
        byte[] newPWBytes = pwModRequest.getNewPasswordBytes();
        if (userIdentity == null) {
            targetDN = handler.getAuthenticatedDN();
        } else {
            String lowerUserIdentity = StaticUtils.toLowerCase(userIdentity);
            if (lowerUserIdentity.startsWith("dn:") || lowerUserIdentity.startsWith("u:")) {
                try {
                    targetDN = handler.getDNForAuthzID(userIdentity);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    return new PasswordModifyExtendedResult(messageID, le.getResultCode(), le.getMessage(), le.getMatchedDN(), le.getReferralURLs(), null, le.getResponseControls());
                }
            }
            try {
                targetDN = new DN(userIdentity);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new PasswordModifyExtendedResult(messageID, ResultCode.INVALID_DN_SYNTAX, ListenerMessages.ERR_PW_MOD_EXTOP_CANNOT_PARSE_USER_IDENTITY.get(userIdentity), null, null, null, null);
            }
        }
        if (targetDN == null || targetDN.isNullDN()) {
            return new PasswordModifyExtendedResult(messageID, ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_PW_MOD_NO_IDENTITY.get(), null, null, null, null);
        }
        ReadOnlyEntry userEntry = handler.getEntry(targetDN);
        if (userEntry == null) {
            return new PasswordModifyExtendedResult(messageID, ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_PW_MOD_EXTOP_CANNOT_GET_USER_ENTRY.get(targetDN.toString()), null, null, null, null);
        }
        List<String> passwordAttributes = handler.getPasswordAttributes();
        if (passwordAttributes.isEmpty()) {
            return new PasswordModifyExtendedResult(messageID, ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_PW_MOD_EXTOP_NO_PW_ATTRS.get(), null, null, null, null);
        }
        if (oldPWBytes == null) {
            if (handler.getAuthenticatedDN().isNullDN()) {
                return new PasswordModifyExtendedResult(messageID, ResultCode.UNWILLING_TO_PERFORM, ListenerMessages.ERR_PW_MOD_EXTOP_NO_AUTHENTICATION.get(), null, null, null, null);
            }
        } else {
            List<InMemoryDirectoryServerPassword> passwordList = handler.getPasswordsInEntry(userEntry, pwModRequest.getRawOldPassword());
            if (passwordList.isEmpty()) {
                return new PasswordModifyExtendedResult(messageID, ResultCode.INVALID_CREDENTIALS, null, null, null, null, null);
            }
        }
        if (newPWBytes == null) {
            SecureRandom random = ThreadLocalSecureRandom.get();
            byte[] pwAlphabet = StaticUtils.getBytes("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
            pwBytes = new byte[8];
            for (int i = 0; i < pwBytes.length; ++i) {
                pwBytes[i] = pwAlphabet[random.nextInt(pwAlphabet.length)];
            }
            genPW = new ASN1OctetString(pwBytes);
        } else {
            genPW = null;
            pwBytes = newPWBytes;
        }
        List<InMemoryDirectoryServerPassword> existingPasswords = handler.getPasswordsInEntry(userEntry, null);
        ArrayList<Modification> mods = new ArrayList<Modification>(existingPasswords.size() + 1);
        if (existingPasswords.isEmpty()) {
            mods.add(new Modification(ModificationType.REPLACE, passwordAttributes.get(0), pwBytes));
        } else {
            HashSet<String> usedPWAttrs = new HashSet<String>(StaticUtils.computeMapCapacity(existingPasswords.size()));
            for (InMemoryDirectoryServerPassword p : existingPasswords) {
                String attr = StaticUtils.toLowerCase(p.getAttributeName());
                if (usedPWAttrs.isEmpty()) {
                    usedPWAttrs.add(attr);
                    mods.add(new Modification(ModificationType.REPLACE, p.getAttributeName(), pwBytes));
                    continue;
                }
                if (usedPWAttrs.contains(attr)) continue;
                usedPWAttrs.add(attr);
                mods.add(new Modification(ModificationType.REPLACE, p.getAttributeName()));
            }
        }
        if (noOperation) {
            return new PasswordModifyExtendedResult(messageID, ResultCode.NO_OPERATION, ListenerMessages.INFO_PW_MOD_EXTOP_NO_OP.get(), null, null, genPW, null);
        }
        try {
            handler.modifyEntry(userEntry.getDN(), mods);
            return new PasswordModifyExtendedResult(messageID, ResultCode.SUCCESS, null, null, null, genPW, null);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new PasswordModifyExtendedResult(messageID, le.getResultCode(), ListenerMessages.ERR_PW_MOD_EXTOP_CANNOT_CHANGE_PW.get(userEntry.getDN(), le.getMessage()), le.getMatchedDN(), le.getReferralURLs(), null, null);
        }
    }
}

